/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.block.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AnubiasBlock
extends BushBlock
implements BonemealableBlock,
LiquidBlockContainer {
    protected static final VoxelShape FLOORNORTHSOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)9.0, (double)15.0);
    protected static final VoxelShape FLOOREASTWEST = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)9.0, (double)14.0);
    protected static final VoxelShape SOUTHWALL = Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)8.0);
    protected static final VoxelShape WESTWALL = Block.m_49796_((double)8.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0);
    protected static final VoxelShape NORTHWALL = Block.m_49796_((double)2.0, (double)1.0, (double)8.0, (double)14.0, (double)15.0, (double)16.0);
    protected static final VoxelShape EASTWALL = Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)8.0, (double)15.0, (double)14.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;

    public AnubiasBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.FLOOR));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if ((AttachFace)pState.m_61143_(FACE) == AttachFace.FLOOR) {
            if (pState.m_61143_((Property)FACING) == Direction.NORTH || pState.m_61143_((Property)FACING) == Direction.SOUTH) {
                return FLOORNORTHSOUTH;
            }
            return FLOOREASTWEST;
        }
        return switch (direction) {
            case Direction.EAST -> EASTWALL;
            case Direction.WEST -> WESTWALL;
            case Direction.SOUTH -> SOUTHWALL;
            case Direction.NORTH -> NORTHWALL;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return AnubiasBlock.canAttach(pLevel, pPos, AnubiasBlock.getConnectedDirection(pState).m_122424_());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        return pReader.m_8055_(blockpos).m_60783_((BlockGetter)pReader, blockpos, pDirection.m_122424_()) && !pReader.m_8055_(blockpos).m_60713_(Blocks.f_50450_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        if (fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8) {
            for (Direction direction : pContext.m_6232_()) {
                BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)FACING, (Comparable)pContext.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
                if (!blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
                return blockstate;
            }
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockstate;
        BlockState blockState = blockstate = AnubiasBlock.getConnectedDirection(pState).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (!blockstate.m_60795_()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return blockstate;
    }

    public FluidState m_5888_(BlockState p_154537_) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return true;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        AnubiasBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{FACE});
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        switch ((AttachFace)pState.m_61143_(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)pState.m_61143_((Property)FACING);
    }
}

