/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ArapaimaPart;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.FishFollowParentGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;

public class ArapaimaEntity
extends BucketableFishEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState idleGroundAnimationState = new AnimationState();
    public final ArapaimaPart head;
    public final ArapaimaPart tail;
    public final ArapaimaPart[] allParts;
    public boolean isLandNavigator;
    public int ringBufferIndex = -1;
    public final float[][] ringBuffer = new float[64][3];
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);

    public ArapaimaEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.head = new ArapaimaPart<ArapaimaEntity>(this, 1.2f, 0.9f);
        this.tail = new ArapaimaPart<ArapaimaEntity>(this, 1.2f, 0.9f);
        this.allParts = new ArapaimaPart[]{this.head, this.tail};
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(true);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new LookControl((Mob)this);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, true);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.isLandNavigator = false;
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25){

            protected boolean m_202729_() {
                return super.m_202729_() && ArapaimaEntity.this.m_20072_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new MoveToWaterGoal(this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new FishFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && !player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YAFMItems.FISHING_HAT.get());
            }
            return false;
        }));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10){

            public boolean m_8036_() {
                return ArapaimaEntity.this.m_20072_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
        if (this.m_20072_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20072_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
        this.idleGroundAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21525_() && !this.m_6162_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.m_146908_();
                    this.ringBuffer[i][1] = (float)this.m_20186_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.m_146908_();
            this.ringBuffer[this.ringBufferIndex][1] = (float)this.m_20186_();
            Vec3[] avector3d = new Vec3[this.allParts.length];
            for (int j = 0; j < this.allParts.length; ++j) {
                this.allParts[j].collideWithNearbyEntities();
                avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
            }
            float f17 = this.m_146908_() * ((float)Math.PI / 180);
            float pitch = this.m_146909_() * ((float)Math.PI / 180);
            float xRotDiv90 = Math.abs(this.m_146909_() / 90.0f);
            float f3 = Mth.m_14031_((float)f17) * (1.0f - xRotDiv90);
            float f18 = Mth.m_14089_((float)f17) * (1.0f - xRotDiv90);
            this.setPartPosition(this.head, f3 * -1.6f, -pitch * 0.8f, -f18 * -1.6f);
            this.setPartPosition(this.tail, f3 * 1.6f, pitch * 0.3f, f18 * -1.6f);
            for (int l = 0; l < this.allParts.length; ++l) {
                this.allParts[l].f_19854_ = avector3d[l].f_82479_;
                this.allParts[l].f_19855_ = avector3d[l].f_82480_;
                this.allParts[l].f_19856_ = avector3d[l].f_82481_;
                this.allParts[l].f_19790_ = avector3d[l].f_82479_;
                this.allParts[l].f_19791_ = avector3d[l].f_82480_;
                this.allParts[l].f_19792_ = avector3d[l].f_82481_;
            }
        }
    }

    public boolean isMultipartEntity() {
        return !this.m_6162_();
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    private void setPartPosition(ArapaimaPart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    public boolean attackEntityPartFrom(ArapaimaPart entityArapaimaPart, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    public InteractionResult interactEntityPartFrom(ArapaimaPart entityArapaimaPart, Player player, InteractionHand hand) {
        return this.m_6071_(player, hand);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)YAFMItems.ARAPAIMA_SPAWN_EGG.get());
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        ArapaimaEntity baby = (ArapaimaEntity)((EntityType)YAFMEntities.ARAPAIMA.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.m_27497_(true);
        }
        return baby;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (!this.m_6162_() && item.m_150930_(Items.f_42446_)) {
            pPlayer.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)item, (Player)pPlayer, (ItemStack)Items.f_42455_.m_7968_());
            pPlayer.m_21008_(pHand, itemstack1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("Age", 3)) {
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
            this.m_20301_(this.m_6062_());
        } else if (pReason == MobSpawnType.BUCKET && pDataTag == null) {
            this.setAge(-24000);
            this.m_20301_(this.m_6062_());
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean canBeBucketed() {
        return this.m_6162_();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.ARAPAIMA_BUCKET.get());
    }

    @Override
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    public boolean hasNormalControls() {
        return false;
    }

    @Override
    public boolean canFlop() {
        return false;
    }

    public int m_6062_() {
        return 4800;
    }

    static class MoveToWaterGoal
    extends MoveToBlockGoal {
        private final ArapaimaEntity turtle;

        MoveToWaterGoal(ArapaimaEntity pTurtle, double pSpeedModifier) {
            super((PathfinderMob)pTurtle, pSpeedModifier, 24);
            this.turtle = pTurtle;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.turtle.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return !this.turtle.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_);
        }
    }
}

