/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.Tags;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CatfishEntity
extends BucketableFishEntity
implements GeoEntity {
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.catfish.swim");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.catfish.flop");
    protected static final RawAnimation PIRAIBA_SWIM = RawAnimation.begin().thenLoop("animation.catfish.piraiba_swim");
    protected static final RawAnimation PIRAIBA_FLOP = RawAnimation.begin().thenPlay("animation.catfish.piraiba_flop");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CatfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    @Override
    public boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return switch (this.getVariant()) {
            case 1, 4, 5, 6 -> super.m_6972_(pPose).m_20390_(0.8f, 0.8f);
            case 2 -> super.m_6972_(pPose);
            case 3 -> super.m_6972_(pPose).m_20390_(1.1f, 1.1f);
            default -> super.m_6972_(pPose).m_20390_(1.5f, 1.5f);
        };
    }

    public CatfishEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_6210_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public boolean canBeBucketed() {
        return this.getVariant() != 0 || this.getVariant() == 0 && this.m_6162_();
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Variant", this.getVariant());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("Variant", 3)) {
            this.setVariant(pDataTag.m_128451_("Variant"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else if (pReason == MobSpawnType.SPAWN_EGG || pReason == MobSpawnType.BUCKET && pDataTag == null) {
            this.setVariant(this.f_19796_.m_188503_(7));
            if (this.getVariant() == 0) {
                this.setAge(-24000);
            }
        } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_SWAMP)) {
            switch (this.f_19796_.m_188503_(4)) {
                case 1: {
                    this.setVariant(1);
                    break;
                }
                case 2: {
                    this.setVariant(4);
                    break;
                }
                case 3: {
                    this.setVariant(5);
                    break;
                }
                default: {
                    this.setVariant(6);
                    break;
                }
            }
        } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207605_)) {
            switch (this.f_19796_.m_188503_(5)) {
                case 1: {
                    this.setVariant(1);
                    break;
                }
                case 2: {
                    this.setVariant(4);
                    break;
                }
                case 3: {
                    this.setVariant(5);
                    break;
                }
                case 4: {
                    this.setVariant(3);
                    break;
                }
                default: {
                    this.setVariant(6);
                    break;
                }
            }
        } else if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207610_)) {
            this.setVariant(this.f_19796_.m_188499_() ? 0 : 2);
        }
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        CatfishEntity baby = (CatfishEntity)((EntityType)YAFMEntities.CATFISH.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.setVariant(this.getVariant());
            baby.m_27497_(true);
        }
        return baby;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.CATFISH_BUCKET.get());
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268640_) && !pSource.m_276093_(DamageTypes.f_268440_) && (entity = pSource.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.m_6469_(this.m_269291_().m_269374_((Entity)this), 2.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    protected <E extends CatfishEntity> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            event.setAndContinue(this.getVariant() > 0 ? SWIM : PIRAIBA_SWIM);
        } else {
            event.setAndContinue(this.getVariant() > 0 ? FLOP : PIRAIBA_FLOP);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        CatfishEntity mate = (CatfishEntity)pOtherAnimal;
        return super.canMate(pOtherAnimal) && this.getVariant() == mate.getVariant();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

