/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.CatfishEntity;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.base.AbstractSwimmingBottomDweller;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlecoEntity
extends AbstractSwimmingBottomDweller
implements GeoEntity {
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.pleco.swim");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.pleco.flop");
    protected static final RawAnimation SWIM_GROUND = RawAnimation.begin().thenLoop("animation.pleco.swim_ground");
    protected static final RawAnimation IDLE_GROUND = RawAnimation.begin().thenPlay("animation.pleco.idle_ground");
    protected static final RawAnimation IDLE_SWIM = RawAnimation.begin().thenPlay("animation.pleco.idle_swim");
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PlecoEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && !player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YAFMItems.FISHING_HAT.get());
            }
            return false;
        }));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 50){

            public boolean m_8036_() {
                return PlecoEntity.this.getWantsToSwim() && super.m_8036_();
            }

            public boolean m_8045_() {
                return PlecoEntity.this.getWantsToSwim() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80){

            public boolean m_8036_() {
                return !PlecoEntity.this.getWantsToSwim() && PlecoEntity.this.m_20096_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !PlecoEntity.this.getWantsToSwim() && super.m_8045_();
            }

            @Nullable
            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)1);
            }
        });
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("Age", 3)) {
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        PlecoEntity baby = (PlecoEntity)((EntityType)YAFMEntities.PLECO.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.m_27497_(true);
        }
        return baby;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.PLECO_BUCKET.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    protected <E extends CatfishEntity> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            if (this.m_20096_()) {
                if (this.m_20184_().m_165925_() > 1.0E-6) {
                    event.setAndContinue(SWIM_GROUND);
                } else {
                    event.setAndContinue(IDLE_GROUND);
                }
            } else if (this.m_20184_().m_165925_() > 1.0E-6) {
                event.setAndContinue(SWIM);
            } else {
                event.setAndContinue(IDLE_SWIM);
            }
        } else {
            event.setAndContinue(FLOP);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

