/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.item.custom;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;

public class FishnetItem
extends Item {
    public static final String DATA_CREATURE = "CreatureData";
    static Random random = new Random();

    public FishnetItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (FishnetItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (!target.m_20197_().isEmpty()) {
            target.m_20153_();
        }
        if (!target.m_6095_().m_204039_(YAFMTags.EntityType.FISHNET_BLACKLIST) && target instanceof WaterAnimal || target.m_6095_().m_204039_(YAFMTags.EntityType.FISHNET_ADDITIONS)) {
            if (!level.f_46443_) {
                ItemStack stack1 = new ItemStack((ItemLike)YAFMItems.FISHNET.get());
                CompoundTag targetTag = target.serializeNBT();
                targetTag.m_128359_("OwnerName", player.m_7755_().getString());
                CompoundTag tag = stack1.m_41784_();
                tag.m_128365_(DATA_CREATURE, (Tag)targetTag);
                stack1.m_41751_(tag);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41751_(tag);
                } else if (!player.m_150109_().m_36054_(stack1)) {
                    player.m_36176_(stack1, true);
                } else {
                    player.m_36356_(stack1);
                }
                target.m_146870_();
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11939_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            if (level.f_46443_) {
                double width = target.m_20205_();
                int i = 0;
                while ((double)i <= Math.floor(width) * 25.0) {
                    double x = target.m_20185_();
                    double y = target.m_20186_();
                    double z = target.m_20189_();
                    for (int j = 0; j < 8; ++j) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + (double)(random.nextFloat() / 1.5f), y + 0.25 + (double)(random.nextFloat() / 2.0f), z + (double)(random.nextFloat() / 1.5f), 5.0E-5, 5.0E-5, 5.0E-5);
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + (double)(random.nextFloat() / -1.5f), y + 0.25 + (double)(random.nextFloat() / 2.0f), z + (double)(random.nextFloat() / -1.5f), 5.0E-5, 5.0E-5, 5.0E-5);
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + (double)(random.nextFloat() / -1.5f), y + 0.25 + (double)(random.nextFloat() / 2.0f), z + (double)(random.nextFloat() / 1.5f), 5.0E-5, 5.0E-5, 5.0E-5);
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + (double)(random.nextFloat() / 1.5f), y + 0.25 + (double)(random.nextFloat() / 2.0f), z + (double)(random.nextFloat() / -1.5f), 5.0E-5, 5.0E-5, 5.0E-5);
                    }
                    ++i;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult rt = FishnetItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack stack = player.m_21120_(hand);
        if (rt.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = rt.m_82425_();
        if (!(level.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return new InteractionResultHolder(FishnetItem.releaseEntity(level, player, stack, pos, rt.m_82434_()), (Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent name = (MutableComponent)super.m_7626_(stack);
        if (FishnetItem.containsEntity(stack)) {
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            Object name2 = tag.m_128441_("CustomName") ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")) : ((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_20676_();
            name.m_130946_(" of ").m_7220_((Component)name2);
        }
        return name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (FishnetItem.containsEntity(stack)) {
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            Component name = ((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_20676_();
            tooltip.add((Component)name.m_6881_().m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        } else {
            ChatFormatting[] achatformatting = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            MutableComponent fishnetDesc = Component.m_237115_((String)"fintastic.translatable.fishnet_description");
            fishnetDesc.m_130944_(achatformatting);
            tooltip.add((Component)fishnetDesc);
        }
    }

    public static boolean containsEntity(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41782_() && stack.m_41783_().m_128441_(DATA_CREATURE);
    }

    private static InteractionResult releaseEntity(Level level, Player player, ItemStack stack, BlockPos pos, Direction direction) {
        LivingEntity entity;
        if (!FishnetItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
        EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
        if (type == null || (entity = (LivingEntity)type.m_20615_(level)) == null) {
            return InteractionResult.FAIL;
        }
        EntityDimensions size = entity.m_6972_(entity.m_20089_());
        if (!level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_()) {
            pos = pos.m_5484_(direction, (int)(direction.m_122434_().m_122479_() ? size.f_20377_ : 1.0f));
        }
        entity.m_20248_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        AABB aabb = entity.m_20191_();
        if (!level.m_45756_((Entity)entity, new AABB(aabb.f_82288_, entity.m_20188_() - 0.35, aabb.f_82290_, aabb.f_82291_, entity.m_20188_() + 1.0, aabb.f_82293_))) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            UUID id = entity.m_20148_();
            entity.deserializeNBT(tag);
            entity.m_20084_(id);
            entity.m_7678_((double)pos.m_123341_(), (double)(pos.m_123342_() + direction.m_122430_()) + 1.0, (double)pos.m_123343_(), player.m_146908_(), 0.0f);
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            if (entity instanceof Bucketable) {
                Bucketable fish = (Bucketable)entity;
                fish.m_27497_(true);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41749_(DATA_CREATURE);
            }
            level.m_7967_((Entity)entity);
            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11941_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (context.m_43722_().m_41782_()) {
            ItemStack itemstack = context.m_43722_();
            BlockPos blockpos = context.m_8083_();
            Direction direction = context.m_43719_();
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
            ItemStack stack = context.m_43722_();
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            EntityType type = EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null);
            LivingEntity entity = (LivingEntity)type.m_20615_(context.m_43725_());
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            UUID id = entity.m_20148_();
            entity.deserializeNBT(tag);
            entity.m_20084_(id);
            entity.m_7678_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_() + 0.5, context.m_43723_().m_146908_(), 0.0f);
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            if (!context.m_43723_().m_150110_().f_35937_) {
                stack.m_41749_(DATA_CREATURE);
            }
            if (entity instanceof Bucketable) {
                Bucketable fish = (Bucketable)entity;
                fish.m_27497_(true);
            }
            if (context.m_43725_().m_7967_((Entity)entity)) {
                itemstack.m_41774_(1);
            }
            context.m_43725_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11941_, SoundSource.AMBIENT, 1.0f, 1.0f);
            context.m_43723_().m_21008_(context.m_43724_(), new ItemStack((ItemLike)YAFMItems.FISHNET.get()));
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }
}

