/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.voidarkana.fintastic.common.block.YAFMBlocks;
import net.voidarkana.fintastic.common.block.custom.AlgaeCarpetBlock;
import net.voidarkana.fintastic.common.block.custom.StromatoliteBlock;
import net.voidarkana.fintastic.common.worldgen.AlgaeBonemealConfig;
import net.voidarkana.fintastic.common.worldgen.LiveRockBoulderConfig;
import net.voidarkana.fintastic.common.worldgen.features.AlgaeBonemealFeature;
import net.voidarkana.fintastic.common.worldgen.features.AmphibiousGroundCircleFeature;
import net.voidarkana.fintastic.common.worldgen.features.AnubiasLogFeature;
import net.voidarkana.fintastic.common.worldgen.features.HornWortFeature;
import net.voidarkana.fintastic.common.worldgen.features.LiveRockBoulderFeature;
import net.voidarkana.fintastic.common.worldgen.features.SimpleWaterloggableBlockFeature;
import net.voidarkana.fintastic.common.worldgen.features.UnderwaterVegetationPatchFeature;
import net.voidarkana.fintastic.util.YAFMTags;

public class YAFMConfiguredFeatures {
    public static final DeferredRegister<Feature<?>> MOD_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"fintastic");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HORNWORT_KEY = YAFMConfiguredFeatures.registerKey("hornwort_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUCKWEED_KEY = YAFMConfiguredFeatures.registerKey("duckweed_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANUBIAS_KEY = YAFMConfiguredFeatures.registerKey("anubias_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_ALGAE_VEGETATION = YAFMConfiguredFeatures.registerKey("green_algae_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_ALGAE_PATCH_BONEMEAL = YAFMConfiguredFeatures.registerKey("green_algae_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_ALGAE_VEGETATION_BONEMEAL = YAFMConfiguredFeatures.registerKey("green_algae_vegetation_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_ALGAE_VEGETATION = YAFMConfiguredFeatures.registerKey("red_algae_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_ALGAE_PATCH_BONEMEAL = YAFMConfiguredFeatures.registerKey("red_algae_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_ALGAE_VEGETATION_BONEMEAL = YAFMConfiguredFeatures.registerKey("red_algae_vegetation_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIVE_ROCK_BOULDER = YAFMConfiguredFeatures.registerKey("live_rock_boulder");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STROMATOLITE_PATCH = YAFMConfiguredFeatures.registerKey("stromatolite_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STROMATOLITE_RANDOM_PATCH = YAFMConfiguredFeatures.registerKey("stromatolite_random_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STROMATOLITE_DECORATION = YAFMConfiguredFeatures.registerKey("stromatolite_decoration");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOSSIL_STROMATOLITE_PATCH = YAFMConfiguredFeatures.registerKey("fossil_stromatolite_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOSSIL_STROMATOLITE_DECORATION = YAFMConfiguredFeatures.registerKey("fossil_stromatolite_decoration");
    public static final RegistryObject<Feature<VegetationPatchConfiguration>> ALGAE_PATCH_FEATURE = YAFMConfiguredFeatures.register_feature("algae_patch_feature", () -> new UnderwaterVegetationPatchFeature((Codec<VegetationPatchConfiguration>)VegetationPatchConfiguration.f_161280_));
    public static final RegistryObject<Feature<VegetationPatchConfiguration>> STROMATOLITE_PATCH_FEATURE = YAFMConfiguredFeatures.register_feature("stromatolite_patch_feature", () -> new AmphibiousGroundCircleFeature((Codec<VegetationPatchConfiguration>)VegetationPatchConfiguration.f_161280_));
    public static final RegistryObject<Feature<AlgaeBonemealConfig>> ALGAE_BONEMEAL_FEATURE = YAFMConfiguredFeatures.register_feature("algae_bonemeal_feature", () -> new AlgaeBonemealFeature(AlgaeBonemealConfig.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> HORNWORT_FEATURE = YAFMConfiguredFeatures.register_feature("hornwort_feature", () -> new HornWortFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ANUBIAS_FEATURE = YAFMConfiguredFeatures.register_feature("anubias_feature", () -> new AnubiasLogFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<LiveRockBoulderConfig>> LIVE_ROCK_BOULDER_FEATURE = YAFMConfiguredFeatures.register_feature("live_rock_boulder_feature", () -> new LiveRockBoulderFeature(LiveRockBoulderConfig.CODEC));
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> SIMPLE_WATERLOGGABLE_BLOCK = YAFMConfiguredFeatures.register_feature("simple_waterloggable_block", () -> new SimpleWaterloggableBlockFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holdergetter = context.m_255420_(Registries.f_256911_);
        YAFMConfiguredFeatures.register(context, HORNWORT_KEY, (Feature)HORNWORT_FEATURE.get(), FeatureConfiguration.f_67737_);
        YAFMConfiguredFeatures.register(context, ANUBIAS_KEY, (Feature)ANUBIAS_FEATURE.get(), FeatureConfiguration.f_67737_);
        YAFMConfiguredFeatures.register(context, DUCKWEED_KEY, Feature.f_65763_, new RandomPatchConfiguration(20, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)YAFMBlocks.DUCKWEED.get())))));
        WeightedStateProvider greenAlgaeWSP = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)Blocks.f_50567_.m_49966_().m_61124_((Property)SeaPickleBlock.f_56074_, (Comparable)Integer.valueOf(2))), 4).m_146271_((Object)((BlockState)((Block)YAFMBlocks.GREEN_ALGAE_CARPET.get()).m_49966_().m_61124_((Property)AlgaeCarpetBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))), 25).m_146271_((Object)((Block)YAFMBlocks.CAULERPA.get()).m_49966_(), 50).m_146271_((Object)((Block)YAFMBlocks.SEA_GRAPES.get()).m_49966_(), 10));
        YAFMConfiguredFeatures.register(context, GREEN_ALGAE_VEGETATION, Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)greenAlgaeWSP));
        YAFMConfiguredFeatures.register(context, GREEN_ALGAE_PATCH_BONEMEAL, (Feature)ALGAE_PATCH_FEATURE.get(), new VegetationPatchConfiguration(YAFMTags.Blocks.ALGAE_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.GREEN_ALGAE_BLOCK.get())), PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(GREEN_ALGAE_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.m_146622_((int)1, (int)2), 0.75f));
        YAFMConfiguredFeatures.register(context, GREEN_ALGAE_VEGETATION_BONEMEAL, (Feature)ALGAE_BONEMEAL_FEATURE.get(), new AlgaeBonemealConfig((BlockStateProvider)greenAlgaeWSP, 3, 1));
        WeightedStateProvider redAlgaeWSP = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)YAFMBlocks.DRAGONS_BREATH_ALGAE.get()).m_49966_(), 15).m_146271_((Object)((BlockState)((Block)YAFMBlocks.RED_ALGAE_CARPET.get()).m_49966_().m_61124_((Property)AlgaeCarpetBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))), 25).m_146271_((Object)((Block)YAFMBlocks.RED_ALGAE.get()).m_49966_(), 30).m_146271_((Object)((BlockState)((Block)YAFMBlocks.RED_ALGAE_FAN.get()).m_49966_().m_61124_((Property)BaseCoralPlantBlock.f_49158_, (Comparable)Boolean.valueOf(true))), 25));
        YAFMConfiguredFeatures.register(context, RED_ALGAE_VEGETATION, Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)redAlgaeWSP));
        YAFMConfiguredFeatures.register(context, RED_ALGAE_PATCH_BONEMEAL, (Feature)ALGAE_PATCH_FEATURE.get(), new VegetationPatchConfiguration(YAFMTags.Blocks.ALGAE_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.RED_ALGAE_BLOCK.get())), PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(RED_ALGAE_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.m_146622_((int)1, (int)2), 0.75f));
        YAFMConfiguredFeatures.register(context, RED_ALGAE_VEGETATION_BONEMEAL, (Feature)ALGAE_BONEMEAL_FEATURE.get(), new AlgaeBonemealConfig((BlockStateProvider)redAlgaeWSP, 3, 1));
        YAFMConfiguredFeatures.register(context, LIVE_ROCK_BOULDER, (Feature)LIVE_ROCK_BOULDER_FEATURE.get(), new LiveRockBoulderConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.RED_ALGAE_LIVE_ROCK.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.GREEN_ALGAE_LIVE_ROCK.get())), 0.6f, (Holder<PlacedFeature>)PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(RED_ALGAE_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), (Holder<PlacedFeature>)PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(GREEN_ALGAE_VEGETATION), (PlacementModifier[])new PlacementModifier[0])));
        WeightedStateProvider stromatoliteWSP = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)YAFMBlocks.STROMATOLITE_GROWTHS.get()).m_49966_().m_61124_((Property)StromatoliteBlock.f_49158_, (Comparable)Boolean.valueOf(false))), 10).m_146271_((Object)((BlockState)((Block)YAFMBlocks.STROMATOLITE.get()).m_49966_().m_61124_((Property)StromatoliteBlock.f_49158_, (Comparable)Boolean.valueOf(true))), 4));
        YAFMConfiguredFeatures.register(context, STROMATOLITE_DECORATION, (Feature)SIMPLE_WATERLOGGABLE_BLOCK.get(), new SimpleBlockConfiguration((BlockStateProvider)stromatoliteWSP));
        YAFMConfiguredFeatures.register(context, STROMATOLITE_PATCH, (Feature)STROMATOLITE_PATCH_FEATURE.get(), new VegetationPatchConfiguration(YAFMTags.Blocks.STROMATOLITE_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.STROMATOLITE_BLOCK.get())), PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(STROMATOLITE_DECORATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 3, 0.75f, (IntProvider)UniformInt.m_146622_((int)4, (int)7), 0.2f));
        YAFMConfiguredFeatures.register(context, STROMATOLITE_RANDOM_PATCH, Feature.f_65763_, new RandomPatchConfiguration(2, 3, 0, PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(STROMATOLITE_PATCH), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224777_((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_})}))})));
        WeightedStateProvider fossilStromatoliteWSP = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)YAFMBlocks.FOSSIL_STROMATOLITE_GROWTHS.get()).m_49966_().m_61124_((Property)StromatoliteBlock.f_49158_, (Comparable)Boolean.valueOf(false))), 10).m_146271_((Object)((BlockState)((Block)YAFMBlocks.FOSSIL_STROMATOLITE.get()).m_49966_().m_61124_((Property)StromatoliteBlock.f_49158_, (Comparable)Boolean.valueOf(true))), 4));
        YAFMConfiguredFeatures.register(context, FOSSIL_STROMATOLITE_DECORATION, (Feature)SIMPLE_WATERLOGGABLE_BLOCK.get(), new SimpleBlockConfiguration((BlockStateProvider)fossilStromatoliteWSP));
        YAFMConfiguredFeatures.register(context, FOSSIL_STROMATOLITE_PATCH, (Feature)STROMATOLITE_PATCH_FEATURE.get(), new VegetationPatchConfiguration(YAFMTags.Blocks.STROMATOLITE_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)YAFMBlocks.FOSSIL_STROMATOLITE_BLOCK.get())), PlacementUtils.m_206506_((Holder)holdergetter.m_255043_(FOSSIL_STROMATOLITE_DECORATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 1, 0.75f, (IntProvider)UniformInt.m_146622_((int)4, (int)7), 0.2f));
    }

    public static List<PlacementModifier> worldSurfaceSquaredWithCount(int pCount) {
        return List.of(CountPlacement.m_191628_((int)pCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("fintastic", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static <T extends FeatureConfiguration> RegistryObject<Feature<T>> register_feature(String name, Supplier<Feature<T>> featureSupplier) {
        return MOD_FEATURES.register(name, featureSupplier);
    }

    public static void register(IEventBus eventBus) {
        MOD_FEATURES.register(eventBus);
    }
}

