/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.ForgeEventFactory;

public class AmphibiousGroundCircleFeature
extends Feature<VegetationPatchConfiguration> {
    public AmphibiousGroundCircleFeature(Codec<VegetationPatchConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<VegetationPatchConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        VegetationPatchConfiguration vegetationpatchconfiguration = (VegetationPatchConfiguration)pContext.m_159778_();
        RandomSource randomsource = pContext.m_225041_();
        BlockPos blockpos = pContext.m_159777_();
        Set<BlockPos> set = this.replaceGround(pContext, blockpos);
        this.distributeVegetation(pContext, worldgenlevel, vegetationpatchconfiguration, randomsource, set);
        return !set.isEmpty();
    }

    public Set<BlockPos> replaceGround(FeaturePlaceContext<VegetationPatchConfiguration> pContext, BlockPos pos) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        this.placeCircle(pContext, pos.m_122024_().m_122012_());
        this.placeCircle(pContext, pos.m_122030_(2).m_122012_());
        this.placeCircle(pContext, pos.m_122024_().m_122020_(2));
        this.placeCircle(pContext, pos.m_122030_(2).m_122020_(2));
        for (int j = 0; j < 5; ++j) {
            int k = pContext.m_225041_().m_188503_(64);
            int l = k % 8;
            int i1 = k / 8;
            if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
            set.addAll(this.placeCircle(pContext, pos.m_7918_(-3 + l, -1, -3 + i1)));
        }
        return set;
    }

    private Set<BlockPos> placeCircle(FeaturePlaceContext<VegetationPatchConfiguration> pContext, BlockPos pPos) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                set.addAll(this.placeGroundAt(pContext, pPos.m_7918_(i, 0, j)));
            }
        }
        return set;
    }

    private Set<BlockPos> placeGroundAt(FeaturePlaceContext<VegetationPatchConfiguration> pContext, BlockPos pPos) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        VegetationPatchConfiguration vegetationpatchconfiguration = (VegetationPatchConfiguration)pContext.m_159778_();
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        SimpleStateProvider provider = BlockStateProvider.m_191384_((BlockState)vegetationpatchconfiguration.f_161282_.m_213972_(pContext.m_225041_(), pPos));
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pPos.m_6630_(i);
            if (worldgenlevel.m_8055_(blockpos).m_204336_(vegetationpatchconfiguration.f_161281_)) {
                this.m_5974_((LevelWriter)pContext.m_159774_(), blockpos, ForgeEventFactory.alterGround((LevelSimulatedReader)pContext.m_159774_(), (RandomSource)pContext.m_225041_(), (BlockPos)blockpos, (BlockState)provider.m_213972_(pContext.m_225041_(), pPos)));
                set.add(blockpos);
                break;
            }
            if ((!pContext.m_159774_().m_7433_(pPos, BlockBehaviour.BlockStateBase::m_60795_) || !pContext.m_159774_().m_142433_(pPos, p_225638_ -> p_225638_.m_164512_((Fluid)Fluids.f_76193_))) && i < 0) break;
        }
        return set;
    }

    protected void distributeVegetation(FeaturePlaceContext<VegetationPatchConfiguration> pContext, WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, RandomSource pRandom, Set<BlockPos> pPossiblePositions) {
        for (BlockPos blockpos : pPossiblePositions) {
            if (!(pConfig.f_161288_ > 0.0f) || !(pRandom.m_188501_() < pConfig.f_161288_)) continue;
            this.placeVegetation(pLevel, pConfig, pContext.m_159775_(), pRandom, blockpos);
        }
    }

    protected void placeVegetation(WorldGenLevel pLevel, VegetationPatchConfiguration pConfig, ChunkGenerator pChunkGenerator, RandomSource pRandom, BlockPos pPos) {
        ((PlacedFeature)pConfig.f_161283_.m_203334_()).m_226357_(pLevel, pChunkGenerator, pRandom, pPos.m_121945_(Direction.UP));
    }
}

