/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.util.data;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.voidarkana.fintastic.common.block.YAFMBlocks;

public class YAFMBlockStateProvider
extends BlockStateProvider {
    public YAFMBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "fintastic", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.nonRotateablePillarBlock(YAFMBlocks.STROMATOLITE_BLOCK, "stromatolite_block_top", "stromatolite_block_side");
        this.nonRotateablePillarBlock(YAFMBlocks.CUT_STROMATOLITE_BLOCK, "cut_stromatolite_block_top", "cut_stromatolite_block_side");
        this.nonRotateablePillarBlock(YAFMBlocks.FOSSIL_STROMATOLITE_BLOCK, "fossil_stromatolite_block_top", "fossil_stromatolite_block_side");
        this.simpleBlockWithItem((Block)YAFMBlocks.STROMATOLITE_GROWTHS.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.STROMATOLITE_GROWTHS.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.STROMATOLITE_GROWTHS.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)YAFMBlocks.FOSSIL_STROMATOLITE_GROWTHS.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.FOSSIL_STROMATOLITE_GROWTHS.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.FOSSIL_STROMATOLITE_GROWTHS.get()))).renderType("cutout"));
        this.blockWithItem(YAFMBlocks.DEAD_LIVE_ROCK);
        this.blockWithItem(YAFMBlocks.DEAD_POROUS_LIVE_ROCK);
        this.blockWithItem(YAFMBlocks.STROMATOLITE_BRICKS);
        this.stairsBlock((StairBlock)YAFMBlocks.STROMATOLITE_BRICKS_STAIRS.get(), this.blockTexture((Block)YAFMBlocks.STROMATOLITE_BRICKS.get()));
        this.slabBlock((SlabBlock)YAFMBlocks.STROMATOLITE_BRICKS_SLAB.get(), this.blockTexture((Block)YAFMBlocks.STROMATOLITE_BRICKS.get()), this.blockTexture((Block)YAFMBlocks.STROMATOLITE_BRICKS.get()));
        this.wallBlock((WallBlock)YAFMBlocks.STROMATOLITE_BRICKS_WALL.get(), this.blockTexture((Block)YAFMBlocks.STROMATOLITE_BRICKS.get()));
        this.blockWithItem(YAFMBlocks.GREEN_ALGAE_BLOCK);
        this.blockWithItem(YAFMBlocks.RED_ALGAE_BLOCK);
        this.simpleBlockWithItem((Block)YAFMBlocks.RED_ALGAE.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.RED_ALGAE.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.RED_ALGAE.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)YAFMBlocks.DRAGONS_BREATH_ALGAE.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.DRAGONS_BREATH_ALGAE.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.DRAGONS_BREATH_ALGAE.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)YAFMBlocks.CAULERPA.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.CAULERPA.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.CAULERPA.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)YAFMBlocks.SEA_GRAPES.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.SEA_GRAPES.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.SEA_GRAPES.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)YAFMBlocks.SEA_GRAPES_PLANT.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)YAFMBlocks.SEA_GRAPES_PLANT.get()).m_135815_(), this.blockTexture((Block)YAFMBlocks.SEA_GRAPES_PLANT.get()))).renderType("cutout"));
        this.nonRotateablePillarBlock(YAFMBlocks.RED_ALGAE_LIVE_ROCK, "red_algae_block", "porous_live_rock", "red_algae_live_rock");
        this.nonRotateablePillarBlock(YAFMBlocks.GREEN_ALGAE_LIVE_ROCK, "green_algae_block", "live_rock", "green_algae_live_rock");
    }

    private void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("fintastic:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_()));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void nonRotateablePillarBlock(RegistryObject<Block> blockRegistryObject, String top, String bottom, String side) {
        ResourceLocation rSide = new ResourceLocation("fintastic", "block/" + side);
        ResourceLocation rTop = new ResourceLocation("fintastic", "block/" + top);
        ResourceLocation rBottom = new ResourceLocation("fintastic", "block/" + bottom);
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(this.name((Block)blockRegistryObject.get()), rSide, rBottom, rTop));
    }

    private void nonRotateablePillarBlock(RegistryObject<Block> blockRegistryObject, String top_bottom, String side) {
        ResourceLocation rSide = new ResourceLocation("fintastic", "block/" + side);
        ResourceLocation rTop = new ResourceLocation("fintastic", "block/" + top_bottom);
        ResourceLocation rBottom = new ResourceLocation("fintastic", "block/" + top_bottom);
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(this.name((Block)blockRegistryObject.get()), rSide, rBottom, rTop));
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }
}

