/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.deadlydiamond98.koalalib.KoalaLib;
import net.deadlydiamond98.koalalib.config.KoalaLibConfigs;
import net.fabricmc.loader.api.FabricLoader;
import oshi.util.tuples.Pair;

public class KoalaConfigCreator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final HashMap<String, Pair<Class<?>, String>> MOD_CONFIGS = new HashMap();

    public static void addModConfig(String modID, Class<?> configClass) {
        modID = (String)modID + ".main";
        MOD_CONFIGS.put((String)modID, new Pair(configClass, (Object)""));
        KoalaConfigCreator.readValuesFromConfig(KoalaConfigCreator.getConfigFile((String)modID), configClass);
    }

    public static void addModConfigCategory(String modID, String category, Class<?> configClass) {
        String categoryName = modID + "." + category;
        MOD_CONFIGS.put(categoryName, new Pair(configClass, (Object)(modID + ".main")));
        KoalaConfigCreator.readValuesFromConfig(KoalaConfigCreator.getConfigFile(categoryName), configClass);
    }

    private static void readValuesFromConfig(Path path, Class<?> configClass) {
        try (FileReader reader = new FileReader(path.toFile());){
            Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
            HashMap readConfigData = (HashMap)GSON.fromJson((Reader)reader, type);
            readConfigData.forEach((name, value) -> {
                try {
                    Field field = configClass.getField((String)name);
                    field.set(configClass, KoalaConfigCreator.matchValueToFieldType(value, field));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            KoalaConfigCreator.writeToConfigFile(path, configClass);
        }
        catch (Exception ignored) {
            KoalaConfigCreator.createConfigFile(path, configClass, 2);
        }
    }

    private static Object matchValueToFieldType(Object value, Field field) {
        Class<?> type = field.getType();
        if (value instanceof Double) {
            double numericalValue = Double.parseDouble(value.toString());
            if (type.equals(Integer.TYPE)) {
                return (int)numericalValue;
            }
            if (type.equals(Float.TYPE)) {
                return Float.valueOf((float)numericalValue);
            }
        } else if (field.getType().isEnum()) {
            for (Object enumConstant : field.getType().getEnumConstants()) {
                if (!((Enum)enumConstant).name().equals(value.toString())) continue;
                return enumConstant;
            }
        }
        return value;
    }

    private static void createConfigFile(Path path, Class<?> configClass, int errorID) {
        KoalaConfigCreator.printError(errorID, path);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            KoalaConfigCreator.writeToConfigFile(path, configClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeToConfigFile(Path path, Class<?> configClass) {
        try (FileWriter writer = new FileWriter(path.toFile());){
            HashMap<String, Object> configData = new HashMap<String, Object>();
            for (Field field : configClass.getFields()) {
                configData.put(field.getName(), field.get(field.getName()));
            }
            GSON.toJson(configData, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateAllConfigFiles() {
        MOD_CONFIGS.forEach((name, configScreen) -> KoalaConfigCreator.writeToConfigFile(KoalaConfigCreator.getConfigFile(name), (Class)configScreen.getA()));
    }

    private static Path getConfigFile(String name) {
        return FabricLoader.getInstance().getConfigDir().resolve(name + ".json");
    }

    private static void printError(int id, Path path) {
        String errorString = switch (id) {
            case 0 -> "An invalid value was found in " + String.valueOf(path) + "\nGenerating a new file!";
            case 1 -> "The number of values found in " + String.valueOf(path) + "\ndoesn't match the number it should be.\nGenerating a new file!";
            case 2 -> "Could not find a config file at " + String.valueOf(path) + "\nGenerating a new file!";
            default -> "This message shouldn't be able to print! If you're seeing this, something is extremely wrong!!";
        };
        KoalaLib.LOGGER.info(errorString);
    }

    private static void debugPrint() {
        KoalaConfigCreator.logger("\n");
        KoalaConfigCreator.logger("------------------------------------------------------------------------------");
        try {
            for (Field field : KoalaLibConfigs.Main.class.getFields()) {
                KoalaConfigCreator.logger(field.getName() + " | " + String.valueOf(field.get(field.getName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        KoalaConfigCreator.logger("------------------------------------------------------------------------------\n");
    }

    private static void logger(String str) {
        KoalaLib.LOGGER.info(str);
    }
}

