/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.mixin.entity.magic;

import net.deadlydiamond98.koalalib.ToggleableContent;
import net.deadlydiamond98.koalalib.common.items.magic.IShowsMagicBar;
import net.deadlydiamond98.koalalib.networking.packets.s2c.EntityMagicUpdateS2CPacket;
import net.deadlydiamond98.koalalib.util.magic.MagicBarHelper;
import net.deadlydiamond98.koalalib.util.mixindata.IMagicBarMixinData;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMagicMixin
implements IMagicBarMixinData {
    @Unique
    private int koalalib$manaLevel;
    @Unique
    private int koalalib$maxManaLevel = 100;
    @Unique
    private int koalalib$manaRegenDelay;
    @Unique
    private boolean koalalib$hasManaRegen = true;
    @Unique
    private int koalalib$manaBarRenderTime;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (ToggleableContent.isMagicBarEnabled()) {
            class_1309 entity = (class_1309)this;
            if (!entity.method_37908().field_9236) {
                this.koalalib$regenManaBar(entity);
            } else {
                this.koalalib$updateManaBarClient(entity);
            }
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void onSave(class_2487 nbt, CallbackInfo info) {
        nbt.method_10569("ManaLevelKoalaLib", this.koalalib$manaLevel);
        nbt.method_10569("MaxManaLevelKoalaLib", this.koalalib$maxManaLevel);
        nbt.method_10556("ManaRegenerationEnabledKoalaLib", this.koalalib$hasManaRegen);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void onLoad(class_2487 nbt, CallbackInfo info) {
        if (nbt.method_10545("ManaLevelKoalaLib")) {
            this.koalalib$manaLevel = nbt.method_10550("ManaLevelKoalaLib");
        }
        if (nbt.method_10545("MaxManaLevelKoalaLib")) {
            this.koalalib$maxManaLevel = nbt.method_10550("MaxManaLevelKoalaLib");
        }
        if (nbt.method_10545("ManaRegenerationEnabledKoalaLib")) {
            this.koalalib$hasManaRegen = nbt.method_10577("ManaRegenerationEnabledKoalaLib");
        }
    }

    @Unique
    private void koalalib$updateManaBarClient(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1792 currentHandItem = player.method_6047().method_7909();
            class_1792 offHandItem = player.method_6079().method_7909();
            if (currentHandItem instanceof IShowsMagicBar || offHandItem instanceof IShowsMagicBar) {
                this.koalalib$setMagicBarRenderTime(100);
            }
            this.koalalib$setMagicBarRenderTime(Math.max(0, --this.koalalib$manaBarRenderTime));
        }
    }

    @Unique
    private void koalalib$regenManaBar(class_1309 entity) {
        if (this.koalalib$manaRegenDelay++ < 0) {
            return;
        }
        if (entity.field_6012 % 12 == 0 && this.koalalib$isManaRegenEnabled()) {
            class_1657 player;
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_7344().method_7587()) {
                return;
            }
            int regenRate = (int)Math.max(Math.floor(Math.min(Math.floor(Math.pow((double)this.koalalib$getMana() / (double)this.koalalib$getMaxMana() * ((double)this.koalalib$getMaxMana() / 100.0) * 0.8, -1.0)), 5.0)), 1.0);
            MagicBarHelper.addMana(entity, regenRate);
        }
    }

    @Unique
    private void koalalib$sendMagicUpdatePacket() {
        class_1309 entity = (class_1309)this;
        if (!entity.method_37908().method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            EntityMagicUpdateS2CPacket.send((class_3222)player, this.koalalib$manaLevel, this.koalalib$maxManaLevel);
        }
    }

    @Override
    public void koalalib$setMana(int value) {
        this.koalalib$manaLevel = value;
        this.koalalib$sendMagicUpdatePacket();
    }

    @Override
    public int koalalib$getMana() {
        return this.koalalib$manaLevel;
    }

    @Override
    public void koalalib$setMaxMana(int value) {
        this.koalalib$maxManaLevel = value;
        this.koalalib$sendMagicUpdatePacket();
    }

    @Override
    public int koalalib$getMaxMana() {
        return this.koalalib$maxManaLevel;
    }

    @Override
    public void koalalib$setManaRegenAbility(boolean value) {
        this.koalalib$hasManaRegen = value;
    }

    @Override
    public boolean koalalib$isManaRegenEnabled() {
        return this.koalalib$hasManaRegen;
    }

    @Override
    public void koalalib$setMagicBarRenderTime(int value) {
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_1657) {
            this.koalalib$manaBarRenderTime = value;
        }
    }

    @Override
    public int koalalib$getMagicBarRenderTime() {
        class_1309 entity = (class_1309)this;
        return entity instanceof class_1657 ? this.koalalib$manaBarRenderTime : 0;
    }

    @Override
    public void koalalib$applyRegenDelay(boolean value) {
        if (value) {
            this.koalalib$manaRegenDelay = (int)Math.floor(Math.min(0.7 * (1.0 - (double)this.koalalib$getMana() / (double)this.koalalib$getMaxMana() * 500.0 + 45.0), -60.0));
        }
    }
}

