/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.EnchantmentSwitchClient;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_8000;
import org.jetbrains.annotations.Nullable;

public class TriggerLockRenderHandler {
    public static final int MAX_TRIGGER_TIME = 72000;
    private static float triggerTime;
    @Nullable
    private static class_1735 hoveredSlot;

    public static EventResult onRenderTooltip(class_332 guiGraphics, class_327 font, int mouseX, int mouseY, List<class_5684> components, class_8000 positioner) {
        class_5684 class_56842;
        if (triggerTime > 0.0f && class_310.method_1551().field_1755 instanceof class_465 && hoveredSlot != null && hoveredSlot.method_7681() && !components.isEmpty() && (class_56842 = components.getFirst()) instanceof class_5683) {
            class_5683 textTooltip = (class_5683)class_56842;
            StringBuilder builder = new StringBuilder();
            textTooltip.field_27997.accept((width, style, codePoint) -> {
                builder.append(Character.toChars(codePoint));
                return true;
            });
            class_2561 hoverName = hoveredSlot.method_7677().method_7964();
            if (hoverName.getString().contentEquals(builder)) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onAfterRender(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (screen.method_17577().method_34255().method_7960() && TriggerLockRenderHandler.isKeyDown(EnchantmentSwitchClient.EDIT_ENCHANTMENTS_KEY_MAPPING)) {
            class_1735 hoveredSlot = screen.field_2787;
            if (TriggerLockRenderHandler.hoveredSlot != hoveredSlot) {
                TriggerLockRenderHandler.resetTriggerValues(hoveredSlot);
            }
            if (TriggerLockRenderHandler.isValidSlot(hoveredSlot, (class_1657)screen.field_22787.field_1724)) {
                TriggerLockRenderHandler.incrementTriggerTime(screen, hoveredSlot, partialTick);
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)screen.field_2776, (float)screen.field_2800);
                float animationProgress = Math.clamp(triggerTime / (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks, 0.0f, 1.0f);
                int posX = hoveredSlot.field_7873;
                int posY = hoveredSlot.field_7872 + class_3532.method_15375((float)(16.0f * (1.0f - animationProgress)));
                guiGraphics.method_25294(posX, posY, posX + 16, posY + class_3532.method_15386((float)(16.0f * animationProgress)), -1990870528);
                guiGraphics.method_51448().popMatrix();
            }
        } else {
            TriggerLockRenderHandler.resetTriggerValues(null);
        }
    }

    public static void resetTriggerValues(@Nullable class_1735 hoveredSlot) {
        triggerTime = 0.0f;
        TriggerLockRenderHandler.hoveredSlot = hoveredSlot;
    }

    private static boolean isValidSlot(@Nullable class_1735 slot, class_1657 player) {
        if (slot != null && slot.method_32754(player)) {
            class_1799 itemStack = slot.method_7677();
            return itemStack.method_7942();
        }
        return false;
    }

    private static void incrementTriggerTime(class_465<?> screen, class_1735 slot, float partialTick) {
        float f;
        triggerTime += partialTick;
        if (f >= (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks && triggerTime < 72000.0f) {
            screen.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            TriggerLockRenderHandler.executeTriggerAction(screen, slot);
        }
    }

    private static void executeTriggerAction(class_465<?> screen, class_1735 slot) {
        TriggerLockRenderHandler.resetTriggerValues(null);
        screen.field_22787.method_1507((class_437)new EditEnchantmentsScreen((class_437)screen, screen.method_17577().field_7763, slot.method_7677(), TriggerLockRenderHandler.getSlotIndex(slot)));
    }

    public static int getSlotIndex(class_1735 slot) {
        int n;
        if (slot instanceof class_481.class_484) {
            class_481.class_484 slotWrapper = (class_481.class_484)slot;
            n = slotWrapper.field_2898.field_7874;
        } else {
            n = slot.field_7874;
        }
        return n;
    }

    public static boolean isKeyDown(class_304 keyMapping) {
        if (keyMapping.field_1655.method_1442() == class_3675.class_307.field_1668 && keyMapping.field_1655.method_1444() != class_3675.field_16237.method_1444()) {
            return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)keyMapping.field_1655.method_1444());
        }
        return false;
    }
}

