/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.gui.components;

import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EnchantmentState;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;

public class ClickableEnchantmentButton
extends SpritelessImageButton {
    private final boolean isPresent;

    public ClickableEnchantmentButton(int x, int y, Holder<Enchantment> enchantment, EnchantmentState enchantmentState, Button.OnPress onPress) {
        super(x, y, 126, 20, 0, 166, 20, EditEnchantmentsScreen.EDIT_ENCHANTMENTS_TEXTURE, 256, 256, onPress, enchantmentState.getDisplayName(enchantment));
        this.isPresent = enchantmentState.isPresent();
        this.setTextureLayout(LEGACY_TEXTURE_LAYOUT);
        this.active = !enchantmentState.isInactive();
        TooltipBuilder.create(enchantmentState.getTooltip(enchantment)).splitLines().build((AbstractWidget)this);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(this.resourceLocation, this.getX() + 2, this.getY() + 2, (float)(147 + (this.isPresent ? 0 : 16)), (float)(166 + 16 * this.getTextureY()), 16, 16, this.textureWidth, this.textureHeight);
        this.renderString(guiGraphics, Minecraft.getInstance().font, this.getFontColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
        this.renderScrollingString(guiGraphics, font, 2, color);
    }

    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int borderGap, int color) {
        int startX = this.getX() + 20 + borderGap;
        int endX = this.getX() + this.getWidth() - borderGap;
        ClickableEnchantmentButton.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getMessage(), (int)startX, (int)this.getY(), (int)endX, (int)(this.getY() + this.getHeight()), (int)color);
    }

    private int getFontColor() {
        return !this.isActive() ? 6839882 : (this.isHoveredOrFocused() ? ChatFormatting.YELLOW.getColor() : 0xFFFFFF);
    }
}

