/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.storage;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public final class AddonPersistentStorage
extends SavedData {
    private static final String ROOT = "entries";
    private static final String KEY = "key";
    private static final String VAL = "val";
    private final Map<ResourceLocation, CompoundTag> data = new ConcurrentHashMap<ResourceLocation, CompoundTag>();
    private final ResourceLocation addonId;

    private AddonPersistentStorage() {
        this.addonId = ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"unknown");
    }

    private AddonPersistentStorage(ResourceLocation addonId) {
        this.addonId = addonId;
    }

    public static AddonPersistentStorage get(ServerLevel world, ResourceLocation addonId) {
        String storageKey = AddonPersistentStorage.storageKey(addonId);
        SavedDataType type = new SavedDataType(storageKey, ctx -> new AddonPersistentStorage(addonId), ctx -> CompoundTag.CODEC.xmap(tag -> AddonPersistentStorage.fromNbt(tag, (HolderLookup.Provider)ctx.level().registryAccess(), addonId), storage -> storage.writeNbt(new CompoundTag(), (HolderLookup.Provider)ctx.level().registryAccess())), DataFixTypes.SAVED_DATA_SCOREBOARD);
        return (AddonPersistentStorage)((Object)PersistentStateUtil.get(world, type));
    }

    private static String storageKey(ResourceLocation addonId) {
        String safePath = addonId.getPath().replace('/', '_');
        return "ra_addon_" + addonId.getNamespace() + "_" + safePath;
    }

    public static AddonPersistentStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        return AddonPersistentStorage.fromNbt(tag, lookup, ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"unknown"));
    }

    private static AddonPersistentStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup, ResourceLocation addonId) {
        AddonPersistentStorage s = new AddonPersistentStorage(addonId);
        ListTag list = tag.getListOrEmpty(ROOT);
        for (int i = 0; i < list.size(); ++i) {
            ResourceLocation id;
            CompoundTag e = list.getCompoundOrEmpty(i);
            String keyStr = e.getStringOr(KEY, "");
            if (keyStr.isEmpty() || (id = ResourceLocation.tryParse((String)keyStr)) == null) continue;
            CompoundTag val = e.getCompoundOrEmpty(VAL);
            s.data.put(id, val.copy());
        }
        return s;
    }

    public CompoundTag writeNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceLocation, CompoundTag> en : this.data.entrySet()) {
            CompoundTag e = new CompoundTag();
            e.putString(KEY, en.getKey().toString());
            e.put(VAL, (Tag)en.getValue().copy());
            list.add((Object)e);
        }
        tag.put(ROOT, (Tag)list);
        return tag;
    }

    public Optional<CompoundTag> get(ResourceLocation key) {
        return Optional.ofNullable(this.data.get(key)).map(CompoundTag::copy);
    }

    public void put(ResourceLocation key, CompoundTag value) {
        this.data.put(key, value == null ? new CompoundTag() : value.copy());
        this.setDirty();
    }

    public void remove(ResourceLocation key) {
        if (this.data.remove(key) != null) {
            this.setDirty();
        }
    }

    public Set<ResourceLocation> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }
}

