/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.KeyUtil;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + EdgeStorage.class.getSimpleName()));
    private final double radius;
    private final Map<String, Edge> edges = new ConcurrentHashMap<String, Edge>();

    public EdgeStorage(double radius) {
        this.radius = radius;
    }

    public static EdgeStorage fromNbt(CompoundTag tag, double radius) {
        EdgeStorage storage = new EdgeStorage(radius);
        for (String edgeId : tag.keySet()) {
            CompoundTag entry = tag.getCompoundOrEmpty(edgeId);
            String a = entry.getStringOr("a", "");
            String b = entry.getStringOr("b", "");
            if (a.isEmpty() || b.isEmpty()) continue;
            Status status = NbtUtils.getEnumOrDefault(entry, "status", Status.class, Status.NEW);
            storage.edges.put(edgeId, new Edge(a, b, status));
        }
        return storage;
    }

    public double radius() {
        return this.radius;
    }

    public boolean add(Node a, Node b) {
        if (a.id().equals(b.id())) {
            return false;
        }
        String edgeId = KeyUtil.edgeKey(a.id(), b.id());
        this.edges.put(edgeId, new Edge(a.id(), b.id(), Status.NEW));
        return true;
    }

    public boolean remove(String edgeId) {
        return this.edges.remove(edgeId) != null;
    }

    public Status getStatus(String edgeId) {
        Edge edge = this.edges.get(edgeId);
        return edge == null ? null : edge.status();
    }

    public void setStatus(String edgeId, Status status) {
        Edge old = this.edges.get(edgeId);
        if (old != null) {
            this.edges.put(edgeId, new Edge(old.nodeA(), old.nodeB(), status));
        }
    }

    public Set<String> neighbors(String nodeId) {
        HashSet<String> set = new HashSet<String>();
        for (Edge edge : this.edges.values()) {
            if (!edge.connects(nodeId)) continue;
            set.add(edge.other(nodeId));
        }
        return Collections.unmodifiableSet(set);
    }

    public Map<String, Edge> all() {
        return Collections.unmodifiableMap(new HashMap<String, Edge>(this.edges));
    }

    public Map<String, Status> allWithStatus() {
        HashMap<String, Status> map = new HashMap<String, Status>();
        for (Map.Entry<String, Edge> e : this.edges.entrySet()) {
            map.put(e.getKey(), e.getValue().status());
        }
        return Collections.unmodifiableMap(map);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        for (Edge edge : this.edges.values()) {
            CompoundTag entry = new CompoundTag();
            entry.putString("a", edge.nodeA());
            entry.putString("b", edge.nodeB());
            entry.putString("status", edge.status().name());
            tag.put(edge.id(), (Tag)entry);
        }
        return tag;
    }

    public void clear() {
        this.edges.clear();
    }

    public static enum Status {
        NEW,
        SUCCESS,
        FAILURE;

    }

    public record Edge(String nodeA, String nodeB, Status status) {
        public String id() {
            return KeyUtil.edgeKey(this.nodeA, this.nodeB);
        }

        public boolean connects(String nodeId) {
            return this.nodeA.equals(nodeId) || this.nodeB.equals(nodeId);
        }

        public String other(String nodeId) {
            return this.nodeA.equals(nodeId) ? this.nodeB : this.nodeA;
        }
    }
}

