/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends SavedData {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private static final String ENTRY_KEY = "k";
    private static final String ENTRY_VALUE = "v";
    public static final SavedDataType<CacheStorage> TYPE = new SavedDataType("road_cache", ctx -> new CacheStorage(), ctx -> CompoundTag.CODEC.xmap(tag -> CacheStorage.fromNbt(tag, (HolderLookup.Provider)ctx.level().registryAccess()), storage -> storage.writeNbt(new CompoundTag(), (HolderLookup.Provider)ctx.level().registryAccess())), DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, Holder<Biome>> biomes = new ConcurrentHashMap<Long, Holder<Biome>>();

    public static CacheStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static CacheStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        HolderLookup.RegistryLookup registry;
        CacheStorage storage = new CacheStorage();
        ListTag hList = tag.getListOrEmpty(HEIGHTS_KEY);
        NbtUtils.fillLongIntMap(hList, storage.heights);
        ListTag sList = tag.getListOrEmpty(STABILITIES_KEY);
        NbtUtils.fillLongDoubleMap(sList, storage.stabilities);
        ListTag bList = tag.getListOrEmpty(BIOMES_KEY);
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(bList.size());
        NbtUtils.fillLongStringMap(bList, biomeIds);
        HolderLookup.RegistryLookup registryLookup = registry = lookup == null ? null : lookup.lookupOrThrow(Registries.BIOME);
        if (registry != null) {
            for (Map.Entry<Long, String> entry : biomeIds.entrySet()) {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.getValue());
                if (id == null) continue;
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
                registry.get(key).ifPresent(regEntry -> storage.biomes.put((Long)entry.getKey(), (Holder<Biome>)regEntry));
            }
        }
        return storage;
    }

    public CompoundTag writeNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.put(HEIGHTS_KEY, (Tag)NbtUtils.toLongIntList(this.heights));
        tag.put(STABILITIES_KEY, (Tag)NbtUtils.toLongDoubleList(this.stabilities));
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(this.biomes.size());
        for (Map.Entry entry : this.biomes.entrySet()) {
            ResourceLocation id = ((Holder)entry.getValue()).unwrapKey().map(ResourceKey::location).orElse(null);
            if (id == null) continue;
            biomeIds.put((Long)entry.getKey(), id.toString());
        }
        tag.put(BIOMES_KEY, (Tag)NbtUtils.toLongStringList(biomeIds));
        return tag;
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, Holder<Biome>> biomes() {
        return this.biomes;
    }
}

