/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PipelineRunner;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPipelineController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadPipelineController.class.getSimpleName()));
    private static final Set<ResourceKey<Level>> INITIALIZED = ConcurrentHashMap.newKeySet();
    private static final Set<ResourceLocation> TARGET_IDS = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Structure>> TARGET_TAGS = new HashSet<TagKey<Structure>>();
    private static final Set<ResourceLocation> TARGET_DIMENSION_IDS = new HashSet<ResourceLocation>();
    private static int tickCounter = 0;

    private RoadPipelineController() {
    }

    public static void init() {
        RoadPipelineController.cacheStructureSelectors();
        tickCounter = 0;
        DebugLog.info(LOGGER, "RoadPipelineController initialized (selectors cached)", new Object[0]);
    }

    public static void refreshStructureSelectorCache() {
        RoadPipelineController.cacheStructureSelectors();
        DebugLog.info(LOGGER, "RoadPipelineController reloaded selectors from config", new Object[0]);
    }

    public static void onSpawnChunkGenerated(ServerLevel world, ChunkAccess chunk) {
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.dimension())) {
            return;
        }
        ChunkPos spawnChunk = new ChunkPos(world.getSharedSpawnPos());
        if (!chunk.getPos().equals((Object)spawnChunk)) {
            return;
        }
        if (INITIALIZED.add((ResourceKey<Level>)world.dimension())) {
            DebugLog.info(LOGGER, "Spawn chunk {} generated in {}, starting INIT pipeline", chunk.getPos(), world.dimension().location());
            PipelineRunner.runPipeline(world, world.getSharedSpawnPos(), PipelineRunner.PipelineMode.INIT);
        }
    }

    public static void onChunkGenerated(ServerLevel world, ChunkAccess chunk) {
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.dimension())) {
            return;
        }
        if (!RoadPipelineController.containsTargetStructure(world, chunk)) {
            return;
        }
        BlockPos center = chunk.getPos().getMiddleBlockPosition(0);
        DebugLog.info(LOGGER, "Chunk {} generated with target structure, starting CHUNK pipeline", chunk.getPos());
        PipelineRunner.runPipeline(world, center, PipelineRunner.PipelineMode.CHUNK);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        ServerLevel world = player.level();
        if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)world.dimension())) {
            return;
        }
        BlockPos pos = player.blockPosition();
        DebugLog.info(LOGGER, "Player {} joined at {}, starting PERIODIC pipeline", player.getName().getString(), pos);
        PipelineRunner.runPipeline(world, pos, PipelineRunner.PipelineMode.PERIODIC);
    }

    public static void onServerTick(MinecraftServer server) {
        int intervalTicks = Math.max(1, RoadArchitect.CONFIG.pipelineIntervalSeconds() * 20);
        if (++tickCounter < intervalTicks) {
            return;
        }
        tickCounter = 0;
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            ServerLevel w = player.level();
            if (!RoadPipelineController.isDimensionEnabled((ResourceKey<Level>)w.dimension())) continue;
            BlockPos pos = player.blockPosition();
            DebugLog.info(LOGGER, "Periodic trigger at player {} pos {}, starting PERIODIC pipeline", player.getName().getString(), pos);
            PipelineRunner.runPipeline(w, pos, PipelineRunner.PipelineMode.PERIODIC);
        }
    }

    public static void onServerStopping() {
        INITIALIZED.clear();
        tickCounter = 0;
        DebugLog.info(LOGGER, "Server stopping, state cleared", new Object[0]);
    }

    private static void cacheStructureSelectors() {
        TARGET_IDS.clear();
        TARGET_TAGS.clear();
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        for (String sel : selectors) {
            if (sel.startsWith("#")) {
                TARGET_TAGS.add((TagKey<Structure>)TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)sel.substring(1))));
                continue;
            }
            TARGET_IDS.add(ResourceLocation.parse((String)sel));
        }
        TARGET_DIMENSION_IDS.clear();
        List<String> dimensionSelectors = RoadArchitect.CONFIG.dimensionSelectors();
        if (dimensionSelectors == null || dimensionSelectors.isEmpty()) {
            TARGET_DIMENSION_IDS.add(Level.OVERWORLD.location());
        } else {
            for (String selector : dimensionSelectors) {
                if (selector.startsWith("#")) {
                    LOGGER.warn("Dimension selector tags are not supported (skipping '{}')", (Object)selector);
                    continue;
                }
                try {
                    TARGET_DIMENSION_IDS.add(ResourceLocation.parse((String)selector));
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Skipping invalid dimension selector '{}': {}", (Object)selector, (Object)ex.getMessage());
                }
            }
            if (TARGET_DIMENSION_IDS.isEmpty()) {
                TARGET_DIMENSION_IDS.add(Level.OVERWORLD.location());
            }
        }
    }

    static boolean isDimensionEnabled(ResourceKey<Level> key) {
        if (TARGET_DIMENSION_IDS.isEmpty()) {
            return key == Level.OVERWORLD;
        }
        return TARGET_DIMENSION_IDS.contains(key.location());
    }

    private static boolean containsTargetStructure(ServerLevel world, ChunkAccess chunk) {
        if (!chunk.hasAnyStructureReferences()) {
            return false;
        }
        Registry registry = world.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (StructureStart start : chunk.getAllStarts().values()) {
            Structure structure = start.getStructure();
            ResourceLocation id = registry.getKey((Object)structure);
            if (id != null && TARGET_IDS.contains(id)) {
                return true;
            }
            Holder entry = registry.wrapAsHolder((Object)structure);
            if (entry == null) continue;
            for (TagKey<Structure> tag : TARGET_TAGS) {
                if (!entry.is(tag)) continue;
                return true;
            }
        }
        return false;
    }
}

