/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;

public final class WorldCacheState {
    private final CacheStorage storage;
    private final ConcurrentHashMap<Long, ChunkHeightSnapshot> chunkHeights = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, CompletableFuture<ChunkHeightSnapshot>> chunkComputations = new ConcurrentHashMap();
    private final int minWorldY;

    public WorldCacheState(ServerLevel world, CacheStorage storage) {
        this.storage = storage;
        this.minWorldY = world.getMinY();
    }

    public CacheStorage storage() {
        return this.storage;
    }

    public ConcurrentHashMap<Long, ChunkHeightSnapshot> chunkHeights() {
        return this.chunkHeights;
    }

    public ConcurrentHashMap<Long, CompletableFuture<ChunkHeightSnapshot>> chunkComputations() {
        return this.chunkComputations;
    }

    public int minWorldY() {
        return this.minWorldY;
    }

    public Integer lookupHeight(long key, int chunkSide) {
        int x = (int)(key >> 32);
        int z = (int)key;
        long chunkKey = ChunkPos.asLong((int)(x >> 4), (int)(z >> 4));
        ChunkHeightSnapshot snapshot = this.chunkHeights.get(chunkKey);
        if (snapshot == null) {
            return null;
        }
        int mask = chunkSide - 1;
        int localX = x & mask;
        int localZ = z & mask;
        return snapshot.get(localX, localZ);
    }

    public void putChunkSnapshot(long chunkKey, ChunkHeightSnapshot snapshot) {
        this.chunkHeights.put(chunkKey, snapshot);
    }

    public void removeChunkSnapshot(long chunkKey) {
        this.chunkHeights.remove(chunkKey);
        this.chunkComputations.remove(chunkKey);
    }
}

