/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util.cache;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;
import net.oxcodsnet.roadarchitect.util.cache.WorldCacheState;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;

public final class ChunkHeightGenerator {
    private ChunkHeightGenerator() {
    }

    public static ChunkHeightSnapshot generate(ServerLevel world, WorldCacheState state, CacheStorage storage, ChunkPos chunkPos, int chunkSide, int columnsPerChunk) {
        int localZ;
        int localX;
        ChunkGenerator generator = world.getChunkSource().getGenerator();
        if (!(generator instanceof NoiseBasedChunkGenerator)) {
            return null;
        }
        NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)generator;
        RandomState noiseConfig = world.getChunkSource().randomState();
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)noiseGenerator.generatorSettings().value();
        NoiseSettings shape = settings.noiseSettings().clampToHeightAccessor((LevelHeightAccessor)world);
        int horizontalBlockSize = shape.getCellWidth();
        int verticalBlockSize = shape.getCellHeight();
        if (horizontalBlockSize <= 0 || verticalBlockSize <= 0) {
            return null;
        }
        int horizontalCellCount = Math.max(1, chunkSide / horizontalBlockSize);
        int verticalCellCount = Mth.floorDiv((int)shape.height(), (int)verticalBlockSize);
        if (verticalCellCount <= 0) {
            return null;
        }
        int[] heights = new int[columnsPerChunk];
        Arrays.fill(heights, state.minWorldY());
        boolean[] resolved = new boolean[columnsPerChunk];
        int remaining = columnsPerChunk;
        Predicate predicate = Heightmap.Types.WORLD_SURFACE_WG.isOpaque();
        BlockState defaultBlock = settings.defaultBlock();
        int startX = chunkPos.getMinBlockX();
        int startZ = chunkPos.getMinBlockZ();
        int minCellY = Mth.floorDiv((int)shape.minY(), (int)verticalBlockSize);
        AccessibleChunkNoiseSampler sampler = new AccessibleChunkNoiseSampler(horizontalCellCount, noiseConfig, startX, startZ, shape, ChunkHeightGenerator.noBeard(), settings, ChunkHeightGenerator.createFluidSampler(settings), Blender.empty());
        sampler.initializeForFirstCellX();
        long startNanos = System.nanoTime();
        block5: for (int cellX = 0; cellX < horizontalCellCount; ++cellX) {
            sampler.advanceCellX(cellX);
            for (int cellZ = 0; cellZ < horizontalCellCount; ++cellZ) {
                for (int cellY = verticalCellCount - 1; cellY >= 0; --cellY) {
                    sampler.selectCellYZ(cellY, cellZ);
                    for (int voxelY = verticalBlockSize - 1; voxelY >= 0; --voxelY) {
                        int absoluteY = (minCellY + cellY) * verticalBlockSize + voxelY;
                        double fracY = (double)voxelY / (double)verticalBlockSize;
                        sampler.updateForY(absoluteY, fracY);
                        for (int voxelX = horizontalBlockSize - 1; voxelX >= 0; --voxelX) {
                            int globalX = startX + cellX * horizontalBlockSize + voxelX;
                            double fracX = (double)voxelX / (double)horizontalBlockSize;
                            sampler.updateForX(globalX, fracX);
                            for (int voxelZ = horizontalBlockSize - 1; voxelZ >= 0; --voxelZ) {
                                int globalZ = startZ + cellZ * horizontalBlockSize + voxelZ;
                                double fracZ = (double)voxelZ / (double)horizontalBlockSize;
                                sampler.updateForZ(globalZ, fracZ);
                                int localX2 = globalX & chunkSide - 1;
                                int localZ2 = globalZ & chunkSide - 1;
                                int index = localZ2 * chunkSide + localX2;
                                BlockState stateAtPos = sampler.sampleBlockStateDirect();
                                if (resolved[index]) continue;
                                if (stateAtPos == null) {
                                    stateAtPos = defaultBlock;
                                }
                                if (!predicate.test(stateAtPos)) continue;
                                heights[index] = absoluteY + 1;
                                resolved[index] = true;
                                if (--remaining == 0) break block5;
                            }
                        }
                    }
                }
            }
        }
        sampler.stopInterpolation();
        int noiseColumns = columnsPerChunk - remaining;
        long noiseDuration = System.nanoTime() - startNanos;
        ChunkHeightGenerator.recordLoadDurationPerColumn(noiseDuration, noiseColumns);
        if (noiseColumns > 0) {
            PipelineProfiler.increment("cache.height.loads", noiseColumns);
        }
        if (remaining > 0) {
            for (int index = 0; index < columnsPerChunk; ++index) {
                if (resolved[index]) continue;
                localX = index % chunkSide;
                localZ = index / chunkSide;
                int worldX = startX + localX;
                int worldZ = startZ + localZ;
                PipelineProfiler.increment("cache.height.loads");
                try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.height.load_time");){
                    int value;
                    heights[index] = value = generator.getBaseHeight(worldX, worldZ, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world, noiseConfig);
                    continue;
                }
            }
        }
        int[] index = heights;
        localX = index.length;
        for (localZ = 0; localZ < localX; ++localZ) {
            int value = index[localZ];
            PipelineProfiler.recordValue("cache.height.loaded_value", value);
        }
        boolean dirty = false;
        int writeIndex = 0;
        for (localZ = 0; localZ < chunkSide; ++localZ) {
            int localX3 = 0;
            while (localX3 < chunkSide) {
                int worldX = startX + localX3;
                int worldZ = startZ + localZ;
                long columnKey = ChunkHeightGenerator.hash(worldX, worldZ);
                int value = heights[writeIndex];
                Integer previous = storage.heights().put(columnKey, value);
                if (previous == null || previous != value) {
                    dirty = true;
                }
                ++localX3;
                ++writeIndex;
            }
        }
        if (dirty) {
            storage.setDirty();
        }
        return new ChunkHeightSnapshot(heights, chunkSide);
    }

    private static Aquifer.FluidPicker createFluidSampler(NoiseGeneratorSettings settings) {
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.LAVA.defaultBlockState());
        int seaLevel = settings.seaLevel();
        Aquifer.FluidStatus sea = new Aquifer.FluidStatus(seaLevel, settings.defaultFluid());
        int cutoff = Math.min(-54, seaLevel);
        return (x, y, z) -> y < cutoff ? lava : sea;
    }

    private static void recordLoadDurationPerColumn(long totalNanos, int columns) {
        if (columns <= 0 || totalNanos <= 0L) {
            return;
        }
        long base = totalNanos / (long)columns;
        long remainder = totalNanos % (long)columns;
        for (int i = 0; i < columns; ++i) {
            long sample = base + ((long)i < remainder ? 1L : 0L);
            PipelineProfiler.recordDuration("cache.height.load_time", sample);
        }
    }

    private static DensityFunctions.BeardifierOrMarker noBeard() {
        return LazyBeardifyingHolder.INSTANCE;
    }

    private static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static final class AccessibleChunkNoiseSampler
    extends NoiseChunk {
        AccessibleChunkNoiseSampler(int horizontalCellCount, RandomState noiseConfig, int startBlockX, int startBlockZ, NoiseSettings generationShapeConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings chunkGeneratorSettings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
            super(horizontalCellCount, noiseConfig, startBlockX, startBlockZ, generationShapeConfig, beardifying, chunkGeneratorSettings, fluidLevelSampler, blender);
        }

        BlockState sampleBlockStateDirect() {
            return super.getInterpolatedState();
        }
    }

    private static final class LazyBeardifyingHolder {
        private static final DensityFunctions.BeardifierOrMarker INSTANCE = new DensityFunctions.BeardifierOrMarker(){

            public double compute(DensityFunction.FunctionContext pos) {
                return 0.0;
            }

            public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
                Arrays.fill(densities, 0.0);
            }

            public double minValue() {
                return 0.0;
            }

            public double maxValue() {
                return 0.0;
            }

            public KeyDispatchDataCodec<? extends DensityFunction> codec() {
                return KeyDispatchDataCodec.of((MapCodec)MapCodec.unit((Object)DensityFunctions.constant((double)0.0)));
            }
        };

        private LazyBeardifyingHolder() {
        }
    }
}

