/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.compat.BopCompat;
import net.oxcodsnet.roadarchitect.neoforge.config.RAConfigNeoForgeBridge;
import net.oxcodsnet.roadarchitect.neoforge.events.NeoForgeEventBridge;
import net.oxcodsnet.roadarchitect.neoforge.events.RoadFeatureRegistryNeoForge;
import net.oxcodsnet.roadarchitect.neoforge.events.RoadGraphStateNeoForgeEvents;
import net.oxcodsnet.roadarchitect.neoforge.events.RoadPipelineNeoForgeEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="roadarchitect")
public final class RoadArchitectNeoForge {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect");

    public RoadArchitectNeoForge(IEventBus modBus, ModContainer container, Dist dist) {
        BopCompat.setPresent(ModList.get().isLoaded("biomesoplenty"));
        modBus.addListener(RoadFeatureRegistryNeoForge::register);
        NeoForgeEventBridge.register();
        RoadGraphStateNeoForgeEvents.register();
        RoadPipelineNeoForgeEvents.register();
        RAConfigNeoForgeBridge.bootstrap();
        if (dist.isClient()) {
            RoadArchitectNeoForge.initClient(modBus, container);
        }
        RoadArchitect.init();
        LOGGER.info("Initialized Road Architect on NeoForge");
    }

    private static void initClient(IEventBus modBus, ModContainer container) {
        try {
            Class<?> bootstrap = Class.forName("net.oxcodsnet.roadarchitect.neoforge.client.RAClientBootstrap");
            bootstrap.getMethod("init", IEventBus.class, ModContainer.class).invoke(null, modBus, container);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to initialize Road Architect NeoForge client bootstrap", e);
        }
    }
}

