/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.roadarchitect.config.LampPostConfigEntry;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.defaults.LampPostDefaults;
import net.oxcodsnet.roadarchitect.util.BiomeSelectorUtil;
import net.oxcodsnet.roadarchitect.util.PathDecorUtil;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LampPostConfigResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/LampPostConfig");
    private static final AtomicInteger VERSION = new AtomicInteger();
    private static volatile List<Override> OVERRIDES = List.of();
    private static final Map<Registry<Biome>, CacheEntry> CACHE = new ConcurrentHashMap<Registry<Biome>, CacheEntry>();

    private LampPostConfigResolver() {
    }

    private static void reload(RAConfig config) {
        List<LampPostConfigEntry> entries = config.lampPostOverrides();
        List<LampPostConfigEntry> source = entries == null || entries.isEmpty() ? LampPostDefaults.entries() : entries;
        ArrayList<Override> parsed = new ArrayList<Override>(source.size());
        for (LampPostConfigEntry entry : source) {
            if (entry == null) continue;
            BlockState base = LampPostConfigResolver.resolveBlockState(entry.baseBlock(), "base block");
            BlockState post = LampPostConfigResolver.resolveBlockState(entry.postBlock(), "post block");
            BlockState lamp = LampPostConfigResolver.resolveBlockState(entry.lampBlock(), "lamp block");
            if (base == null || post == null || lamp == null) {
                LOGGER.warn("Skipping lamp post override due to missing block: base={}, post={}, lamp={}", new Object[]{entry.baseBlock(), entry.postBlock(), entry.lampBlock()});
                continue;
            }
            LampPostDecoration decoration = new LampPostDecoration(base, post, lamp);
            parsed.add(new Override(entry.biomeSelectors(), decoration));
        }
        OVERRIDES = List.copyOf(parsed);
        VERSION.incrementAndGet();
        CACHE.clear();
    }

    public static LampPostDecoration resolve(WorldGenLevel world, Holder<Biome> biome, LampPostDecoration fallback, String pathKey, long ordinal) {
        List<Override> overrides = OVERRIDES;
        if (overrides.isEmpty()) {
            return fallback;
        }
        Registry registry = world.registryAccess().registryOrThrow(Registries.BIOME);
        CacheEntry cache = CACHE.compute((Registry<Biome>)registry, (reg, existing) -> {
            int current = VERSION.get();
            if (existing != null && existing.version == current) {
                return existing;
            }
            ArrayList<CompiledOverride> compiled = new ArrayList<CompiledOverride>(overrides.size());
            for (Override override : overrides) {
                List<String> selectors = override.selectors();
                List<HolderSet<Biome>> compiledSelectors = selectors.isEmpty() ? List.of() : BiomeSelectorUtil.compile((Registry<Biome>)reg, selectors);
                compiled.add(new CompiledOverride(override.decoration(), compiledSelectors));
            }
            return new CacheEntry(current, compiled);
        });
        ArrayList<LampPostDecoration> matches = null;
        ArrayList<LampPostDecoration> fallbacks = null;
        for (CompiledOverride entry : cache.overrides) {
            List<HolderSet<Biome>> selectors = entry.selectors();
            if (selectors.isEmpty()) {
                if (fallbacks == null) {
                    fallbacks = new ArrayList<LampPostDecoration>();
                }
                fallbacks.add(entry.decoration());
                continue;
            }
            if (!BiomeSelectorUtil.matches(biome, selectors)) continue;
            if (matches == null) {
                matches = new ArrayList<LampPostDecoration>();
            }
            matches.add(entry.decoration());
        }
        if (matches != null && !matches.isEmpty()) {
            int choice = PathDecorUtil.detInt(pathKey, ordinal, matches.size());
            return (LampPostDecoration)matches.get(choice);
        }
        if (fallbacks != null && !fallbacks.isEmpty()) {
            int choice = PathDecorUtil.detInt(pathKey, ordinal ^ 0x5F3759DFL, fallbacks.size());
            return (LampPostDecoration)fallbacks.get(choice);
        }
        return fallback;
    }

    private static BlockState resolveBlockState(String raw, String role) {
        if (raw == null || raw.isBlank()) {
            LOGGER.warn("Lamp post override {} is empty", (Object)role);
            return null;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)raw);
        if (id == null) {
            LOGGER.warn("Lamp post override {} '{}' is not a valid identifier", (Object)role, (Object)raw);
            return null;
        }
        return BuiltInRegistries.BLOCK.getOptional(id).map(Block::defaultBlockState).orElseGet(() -> {
            LOGGER.warn("Lamp post override {} '{}' is not registered", (Object)role, (Object)raw);
            return null;
        });
    }

    static {
        RAConfigHolder.listen(LampPostConfigResolver::reload);
    }

    private record Override(List<String> selectors, LampPostDecoration decoration) {
        private Override {
            selectors = selectors == null ? List.of() : List.copyOf(selectors);
        }
    }

    private record CacheEntry(int version, List<CompiledOverride> overrides) {
    }

    private record CompiledOverride(LampPostDecoration decoration, List<HolderSet<Biome>> selectors) {
    }
}

