/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.storage;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public final class AddonPersistentStorage
extends class_18 {
    private static final String ROOT = "entries";
    private static final String KEY = "key";
    private static final String VAL = "val";
    public static final class_18.class_8645<AddonPersistentStorage> TYPE_DEF = new class_18.class_8645(AddonPersistentStorage::new, AddonPersistentStorage::fromNbt, class_4284.field_45079);
    private final Map<class_2960, class_2487> data = new ConcurrentHashMap<class_2960, class_2487>();
    private final class_2960 addonId;

    private AddonPersistentStorage() {
        this.addonId = class_2960.method_60655((String)"roadarchitect", (String)"unknown");
    }

    private AddonPersistentStorage(class_2960 addonId) {
        this.addonId = addonId;
    }

    public static AddonPersistentStorage get(class_3218 world, class_2960 addonId) {
        String storageKey = AddonPersistentStorage.storageKey(addonId);
        return (AddonPersistentStorage)((Object)PersistentStateUtil.get(world, new class_18.class_8645(() -> new AddonPersistentStorage(addonId), (tag, lookup) -> AddonPersistentStorage.fromNbt(tag, lookup, addonId), class_4284.field_45079), storageKey));
    }

    private static String storageKey(class_2960 addonId) {
        String safePath = addonId.method_12832().replace('/', '_');
        return "ra_addon_" + addonId.method_12836() + "_" + safePath;
    }

    public static AddonPersistentStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        return AddonPersistentStorage.fromNbt(tag, lookup, class_2960.method_60655((String)"roadarchitect", (String)"unknown"));
    }

    private static AddonPersistentStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup, class_2960 addonId) {
        AddonPersistentStorage s = new AddonPersistentStorage(addonId);
        class_2499 list = tag.method_10554(ROOT, 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 e = list.method_10602(i);
            class_2960 id = class_2960.method_12829((String)e.method_10558(KEY));
            if (id == null) continue;
            class_2487 val = e.method_10562(VAL);
            s.data.put(id, val.method_10553());
        }
        return s;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2960, class_2487> en : this.data.entrySet()) {
            class_2487 e = new class_2487();
            e.method_10582(KEY, en.getKey().toString());
            e.method_10566(VAL, (class_2520)en.getValue().method_10553());
            list.add((Object)e);
        }
        tag.method_10566(ROOT, (class_2520)list);
        return tag;
    }

    public Optional<class_2487> get(class_2960 key) {
        return Optional.ofNullable(this.data.get(key)).map(class_2487::method_10553);
    }

    public void put(class_2960 key, class_2487 value) {
        this.data.put(key, value == null ? new class_2487() : value.method_10553());
    }

    public void remove(class_2960 key) {
        this.data.remove(key);
    }

    public Set<class_2960> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }
}

