/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import net.oxcodsnet.roadarchitect.util.StructureLocator;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureScanManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + StructureScanManager.class.getSimpleName()));

    static void scan(class_3218 world, String approach, class_2338 center) {
        StructureScanManager.scan(world, approach, center, 1);
    }

    static void scan(class_3218 world, String approach, class_2338 center, int overallRadius) {
        List<Pair<class_2338, String>> found;
        int scanRadius = 1;
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        DebugLog.info(LOGGER, "[{}] Scan launch: overallRadius={}, scanRadius={}, selectors={}", approach, overallRadius, scanRadius, selectors);
        PipelineProfiler.increment("structure_scan.invocations");
        PipelineProfiler.recordValue("structure_scan.selector_count", selectors.size());
        PipelineProfiler.recordValue("structure_scan.overall_radius", overallRadius);
        PipelineProfiler.recordValue("structure_scan.scan_radius", scanRadius);
        try (PipelineProfiler.Section section = PipelineProfiler.openSection("structure_scan.locator");){
            found = StructureLocator.scanGridAsync(world, center, overallRadius, scanRadius, selectors);
        }
        PipelineProfiler.recordValue("structure_scan.found", found.size());
        DebugLog.info(LOGGER, "[{}] Scanning is completed. Found structures: {}", approach, found.size());
    }

    static void scan(class_3218 world, String approach, class_2338 center, int overallRadius, boolean allowChunkLoads) {
        List<Pair<class_2338, String>> found;
        int scanRadius = 1;
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        DebugLog.info(LOGGER, "[{}] Scan launch: overallRadius={}, scanRadius={}, allowChunkLoads={}, selectors={}", approach, overallRadius, scanRadius, allowChunkLoads, selectors);
        PipelineProfiler.increment("structure_scan.invocations");
        PipelineProfiler.recordValue("structure_scan.selector_count", selectors.size());
        PipelineProfiler.recordValue("structure_scan.overall_radius", overallRadius);
        PipelineProfiler.recordValue("structure_scan.scan_radius", scanRadius);
        PipelineProfiler.increment("structure_scan.allow_chunk_loads" + (allowChunkLoads ? ".enabled" : ".disabled"));
        try (PipelineProfiler.Section section = PipelineProfiler.openSection("structure_scan.locator");){
            found = StructureLocator.scanGridAsync(world, center, overallRadius, scanRadius, selectors, allowChunkLoads);
        }
        PipelineProfiler.recordValue("structure_scan.found", found.size());
        DebugLog.info(LOGGER, "[{}] Scanning is completed. Found structures: {} (allowChunkLoads={})", approach, found.size(), allowChunkLoads);
    }
}

