/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends class_18 {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private static final String ENTRY_KEY = "k";
    private static final String ENTRY_VALUE = "v";
    public static final class_18.class_8645<CacheStorage> TYPE = new class_18.class_8645(CacheStorage::new, CacheStorage::fromNbt, class_4284.field_45083);
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, class_6880<class_1959>> biomes = new ConcurrentHashMap<Long, class_6880<class_1959>>();

    public static CacheStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE, KEY);
    }

    public static CacheStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        CacheStorage storage = new CacheStorage();
        class_2499 hList = tag.method_10554(HEIGHTS_KEY, 10);
        NbtUtils.fillLongIntMap(hList, storage.heights);
        class_2499 sList = tag.method_10554(STABILITIES_KEY, 10);
        NbtUtils.fillLongDoubleMap(sList, storage.stabilities);
        class_2499 bList = tag.method_10554(BIOMES_KEY, 10);
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(bList.size());
        NbtUtils.fillLongStringMap(bList, biomeIds);
        class_7225.class_7226 registry = lookup.method_46762(class_7924.field_41236);
        for (Map.Entry<Long, String> e : biomeIds.entrySet()) {
            class_2960 id = class_2960.method_12829((String)e.getValue());
            if (id == null) continue;
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
            registry.method_46746(key).ifPresent(entry -> storage.biomes.put((Long)e.getKey(), (class_6880<class_1959>)entry));
        }
        return storage;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10566(HEIGHTS_KEY, (class_2520)NbtUtils.toLongIntList(this.heights));
        tag.method_10566(STABILITIES_KEY, (class_2520)NbtUtils.toLongDoubleList(this.stabilities));
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(this.biomes.size());
        for (Map.Entry entry : this.biomes.entrySet()) {
            class_2960 id = ((class_6880)entry.getValue()).method_40230().map(class_5321::method_29177).orElse(null);
            if (id == null) continue;
            biomeIds.put((Long)entry.getKey(), id.toString());
        }
        tag.method_10566(BIOMES_KEY, (class_2520)NbtUtils.toLongStringList(biomeIds));
        return tag;
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, class_6880<class_1959>> biomes() {
        return this.biomes;
    }
}

