/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.config.LampPostConfigEntry;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.defaults.LampPostDefaults;
import net.oxcodsnet.roadarchitect.util.BiomeSelectorUtil;
import net.oxcodsnet.roadarchitect.util.PathDecorUtil;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LampPostConfigResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/LampPostConfig");
    private static final AtomicInteger VERSION = new AtomicInteger();
    private static volatile List<Override> OVERRIDES = List.of();
    private static final Map<class_2378<class_1959>, CacheEntry> CACHE = new ConcurrentHashMap<class_2378<class_1959>, CacheEntry>();

    private LampPostConfigResolver() {
    }

    private static void reload(RAConfig config) {
        List<LampPostConfigEntry> entries = config.lampPostOverrides();
        List<LampPostConfigEntry> source = entries == null || entries.isEmpty() ? LampPostDefaults.entries() : entries;
        ArrayList<Override> parsed = new ArrayList<Override>(source.size());
        for (LampPostConfigEntry entry : source) {
            if (entry == null) continue;
            class_2680 base = LampPostConfigResolver.resolveBlockState(entry.baseBlock(), "base block");
            class_2680 post = LampPostConfigResolver.resolveBlockState(entry.postBlock(), "post block");
            class_2680 lamp = LampPostConfigResolver.resolveBlockState(entry.lampBlock(), "lamp block");
            if (base == null || post == null || lamp == null) {
                LOGGER.warn("Skipping lamp post override due to missing block: base={}, post={}, lamp={}", new Object[]{entry.baseBlock(), entry.postBlock(), entry.lampBlock()});
                continue;
            }
            LampPostDecoration decoration = new LampPostDecoration(base, post, lamp);
            parsed.add(new Override(entry.biomeSelectors(), decoration));
        }
        OVERRIDES = List.copyOf(parsed);
        VERSION.incrementAndGet();
        CACHE.clear();
    }

    public static LampPostDecoration resolve(class_5281 world, class_6880<class_1959> biome, LampPostDecoration fallback, String pathKey, long ordinal) {
        List<Override> overrides = OVERRIDES;
        if (overrides.isEmpty()) {
            return fallback;
        }
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41236);
        CacheEntry cache = CACHE.compute((class_2378<class_1959>)registry, (reg, existing) -> {
            int current = VERSION.get();
            if (existing != null && existing.version == current) {
                return existing;
            }
            ArrayList<CompiledOverride> compiled = new ArrayList<CompiledOverride>(overrides.size());
            for (Override override : overrides) {
                List<String> selectors = override.selectors();
                List<class_6885<class_1959>> compiledSelectors = selectors.isEmpty() ? List.of() : BiomeSelectorUtil.compile((class_2378<class_1959>)reg, selectors);
                compiled.add(new CompiledOverride(override.decoration(), compiledSelectors));
            }
            return new CacheEntry(current, compiled);
        });
        ArrayList<LampPostDecoration> matches = null;
        ArrayList<LampPostDecoration> fallbacks = null;
        for (CompiledOverride entry : cache.overrides) {
            List<class_6885<class_1959>> selectors = entry.selectors();
            if (selectors.isEmpty()) {
                if (fallbacks == null) {
                    fallbacks = new ArrayList<LampPostDecoration>();
                }
                fallbacks.add(entry.decoration());
                continue;
            }
            if (!BiomeSelectorUtil.matches(biome, selectors)) continue;
            if (matches == null) {
                matches = new ArrayList<LampPostDecoration>();
            }
            matches.add(entry.decoration());
        }
        if (matches != null && !matches.isEmpty()) {
            int choice = PathDecorUtil.detInt(pathKey, ordinal, matches.size());
            return (LampPostDecoration)matches.get(choice);
        }
        if (fallbacks != null && !fallbacks.isEmpty()) {
            int choice = PathDecorUtil.detInt(pathKey, ordinal ^ 0x5F3759DFL, fallbacks.size());
            return (LampPostDecoration)fallbacks.get(choice);
        }
        return fallback;
    }

    private static class_2680 resolveBlockState(String raw, String role) {
        if (raw == null || raw.isBlank()) {
            LOGGER.warn("Lamp post override {} is empty", (Object)role);
            return null;
        }
        class_2960 id = class_2960.method_12829((String)raw);
        if (id == null) {
            LOGGER.warn("Lamp post override {} '{}' is not a valid identifier", (Object)role, (Object)raw);
            return null;
        }
        return class_7923.field_41175.method_17966(id).map(class_2248::method_9564).orElseGet(() -> {
            LOGGER.warn("Lamp post override {} '{}' is not registered", (Object)role, (Object)raw);
            return null;
        });
    }

    static {
        RAConfigHolder.listen(LampPostConfigResolver::reload);
    }

    private record Override(List<String> selectors, LampPostDecoration decoration) {
        private Override {
            selectors = selectors == null ? List.of() : List.copyOf(selectors);
        }
    }

    private record CacheEntry(int version, List<CompiledOverride> overrides) {
    }

    private record CompiledOverride(LampPostDecoration decoration, List<class_6885<class_1959>> selectors) {
    }
}

