/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.oxcodsnet.roadarchitect.handlers.PipelineRunner;
import net.oxcodsnet.roadarchitect.handlers.PipelineStage;

@OnlyIn(value=Dist.CLIENT)
public final class LoadingOverlayRenderer {
    private static final int BAR_W = 260;
    private static final int BAR_H = 8;
    private static final int GLOW_W = 80;
    private static final int PERIOD_MS = 2400;

    private LoadingOverlayRenderer() {
    }

    public static void render(GuiGraphics ctx, int screenWidth, int screenHeight) {
        Component stage = LoadingOverlayRenderer.resolveStageLabel();
        LoadingOverlayRenderer.render(ctx, screenWidth, screenHeight, stage);
    }

    public static void render(GuiGraphics ctx, int screenWidth, int screenHeight, Component stage) {
        int x = (screenWidth - 260) / 2;
        int y = screenHeight - 24;
        ctx.fill(x, y, x + 260, y + 8, -14670806);
        ctx.renderOutline(x, y, 260, 8, -5195584);
        long now = System.currentTimeMillis();
        float tLin = (float)(now % 2400L) / 2400.0f;
        float t = tLin * tLin * (3.0f - 2.0f * tLin);
        int path = Math.round(-80.0f + t * 340.0f);
        int segL = x + Math.max(0, path);
        int segR = x + Math.min(260, path + 80);
        if (segR > segL) {
            ctx.fill(segL, y + 1, segR, y + 8 - 1, -11220737);
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int textX = (screenWidth - font.width((FormattedText)stage)) / 2;
        ctx.drawString(font, stage, textX, y - 12, -1, true);
    }

    private static Component resolveStageLabel() {
        try {
            PipelineStage stage = PipelineRunner.getCurrentStage();
            if (stage != null) {
                return stage.label();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Component.literal((String)"Loading\u2026");
    }
}

