/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeSelectorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/BiomeSelectorUtil");
    private static final Map<class_2378<class_1959>, Map<String, class_6885<class_1959>>> CACHE = new ConcurrentHashMap<class_2378<class_1959>, Map<String, class_6885<class_1959>>>();

    private BiomeSelectorUtil() {
    }

    public static List<class_6885<class_1959>> compile(class_2378<class_1959> registry, List<String> selectors) {
        Map local = CACHE.computeIfAbsent(registry, r -> new ConcurrentHashMap());
        class_7066 argType = new class_7066(class_7924.field_41236);
        ArrayList<class_6885<class_1959>> compiled = new ArrayList<class_6885<class_1959>>(selectors.size());
        for (String raw : selectors) {
            class_6885 list;
            block5: {
                if (raw == null || raw.isBlank()) continue;
                list = (class_6885)local.get(raw);
                if (list == null) {
                    try {
                        class_7066.class_7068 predicate = argType.method_41164(new StringReader(raw));
                        class_6885 parsed = ((Optional)predicate.method_41173().map(key -> registry.method_40264(key).map(xva$0 -> class_6885.method_40246((class_6880[])new class_6880[]{xva$0})), arg_0 -> registry.method_40266(arg_0))).orElse(null);
                        if (parsed != null) {
                            class_6885 prev = local.putIfAbsent(raw, parsed);
                            list = prev != null ? prev : parsed;
                            break block5;
                        }
                        LOGGER.warn("Biome selector '{}' resolved to nothing", (Object)raw);
                    }
                    catch (CommandSyntaxException ex) {
                        LOGGER.warn("Biome selector '{}' is invalid: {}", (Object)raw, (Object)ex.getMessage());
                    }
                    continue;
                }
            }
            compiled.add((class_6885<class_1959>)list);
        }
        return compiled;
    }

    public static boolean matches(class_6880<class_1959> biome, List<class_6885<class_1959>> lists) {
        for (class_6885<class_1959> list : lists) {
            if (!list.method_40241(biome)) continue;
            return true;
        }
        return false;
    }
}

