/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class FenceDecoration
implements Decoration {
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int PLACE_FLAGS = 7;
    private final class_2680 fenceState;

    public FenceDecoration(class_2680 fenceState) {
        this.fenceState = fenceState;
    }

    @Override
    public void place(class_5281 world, class_2338 basePos, class_5819 random) {
        class_2338 top = this.computeTop(world, basePos);
        if (top == null) {
            return;
        }
        this.placeFromTopDown(world, top);
    }

    private class_2338 computeTop(class_5281 world, class_2338 base) {
        int bottomY = world.method_31607();
        class_2680 baseState = world.method_8320(base);
        boolean baseSolid = baseState.method_26212((class_1922)world, base);
        if (!baseSolid) {
            class_2338 probe = base.method_10074();
            for (int depth = 0; probe.method_10264() >= bottomY && depth < 3 && !world.method_8320(probe).method_26212((class_1922)world, probe); ++depth) {
                probe = probe.method_10074();
            }
            if (!world.method_8320(probe).method_26212((class_1922)world, probe)) {
                return null;
            }
            class_2338 top = probe.method_10084();
            if (!world.method_8320(top).method_45474()) {
                return null;
            }
            return top;
        }
        class_2338 top = base.method_10084();
        for (int rise = 0; rise < 3 && !world.method_8320(top).method_45474(); ++rise) {
            top = top.method_10084();
        }
        if (!world.method_8320(top).method_45474()) {
            return null;
        }
        class_2338 probe = top.method_10074();
        for (int depth = 0; probe.method_10264() >= bottomY && depth < 3 && !world.method_8320(probe).method_26212((class_1922)world, probe); ++depth) {
            probe = probe.method_10074();
        }
        if (!world.method_8320(probe).method_26212((class_1922)world, probe)) {
            return null;
        }
        return top;
    }

    private void placeFromTopDown(class_5281 world, class_2338 top) {
        world.method_8652(top, this.fenceState, 7);
        class_2338 cur = top.method_10074();
        for (int depth = 0; cur.method_10264() >= world.method_31607() && depth < 3 && !world.method_8320(cur).method_26212((class_1922)world, cur); ++depth) {
            world.method_8652(cur, this.fenceState, 7);
            cur = cur.method_10074();
        }
    }

    public void placeFenceStripe(class_5281 world, List<class_2338> stripe) {
        for (class_2338 base : stripe) {
            class_2338 top = this.computeTop(world, base);
            if (top == null) continue;
            this.placeFromTopDown(world, top);
        }
        for (class_2338 base : stripe) {
            for (int dy = 0; dy <= 3; ++dy) {
                class_2338 p = base.method_10086(dy);
                class_2680 st = world.method_8320(p);
                if (!st.method_27852(this.fenceState.method_26204())) continue;
                for (class_2350 d : class_2350.class_2353.field_11062) {
                    class_2338 n = p.method_10093(d);
                    st = st.method_26191(d, world.method_8320(n), (class_1936)world, p, n);
                }
                world.method_8652(p, st, 7);
            }
        }
    }
}

