/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3749;
import net.minecraft.class_4778;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class LampPostDecoration
implements Decoration {
    private static final int PLACE_FLAGS = 7;
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int HEIGHT = 3;
    private final class_2680 baseState;
    private final class_2680 postState;
    private final class_2680 lampState;
    private final class_2350 facing;

    public LampPostDecoration(class_2680 baseState, class_2680 postState, class_2680 lampState) {
        this(baseState, postState, lampState, class_2350.field_11043);
    }

    private LampPostDecoration(class_2680 baseState, class_2680 postState, class_2680 lampState, class_2350 facing) {
        this.baseState = baseState;
        this.postState = postState;
        this.lampState = lampState;
        this.facing = facing;
    }

    public LampPostDecoration facing(class_2350 facing) {
        return new LampPostDecoration(this.baseState, this.postState, this.lampState, facing);
    }

    @Override
    public void place(class_5281 world, class_2338 basePos, class_5819 random) {
        this.tryPlace(world, basePos, random);
    }

    public boolean tryPlace(class_5281 world, class_2338 basePos, class_5819 random) {
        class_2338 top = this.computeTop(world, basePos);
        if (top == null) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            if (world.method_8320(top.method_10086(i)).method_45474()) continue;
            return false;
        }
        class_2338 armBase = top.method_10086(3);
        class_2338 hook = armBase.method_10093(this.facing);
        if (!world.method_8320(hook).method_45474()) {
            return false;
        }
        class_2338 lantern = hook.method_10074();
        if (!world.method_8320(lantern).method_45474()) {
            return false;
        }
        this.placeSupport(world, top);
        for (int i = 1; i < 3; ++i) {
            world.method_8652(top.method_10086(i), this.postState, 7);
        }
        class_2680 armBaseState = LampPostDecoration.withFenceConnection(this.postState, this.facing);
        world.method_8652(armBase, armBaseState, 7);
        class_2680 hookState = LampPostDecoration.withFenceConnection(this.postState, this.facing.method_10153());
        world.method_8652(hook, hookState, 7);
        class_2680 ls = this.lampState;
        if (ls.method_28498((class_2769)class_3749.field_16545)) {
            ls = (class_2680)ls.method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
        }
        world.method_8652(lantern, ls, 7);
        return true;
    }

    private static class_2680 withFenceConnection(class_2680 state, class_2350 dir) {
        class_2754 wallProp;
        class_2746 fenceProp;
        switch (dir) {
            case field_11043: {
                class_2746 class_27462 = class_2741.field_12489;
                break;
            }
            case field_11035: {
                class_2746 class_27462 = class_2741.field_12540;
                break;
            }
            case field_11034: {
                class_2746 class_27462 = class_2741.field_12487;
                break;
            }
            case field_11039: {
                class_2746 class_27462 = class_2741.field_12527;
                break;
            }
            default: {
                class_2746 class_27462 = fenceProp = null;
            }
        }
        if (fenceProp != null && state.method_28498((class_2769)fenceProp)) {
            return (class_2680)state.method_11657((class_2769)fenceProp, (Comparable)Boolean.valueOf(true));
        }
        switch (dir) {
            case field_11043: {
                class_2754 class_27542 = class_2741.field_22175;
                break;
            }
            case field_11035: {
                class_2754 class_27542 = class_2741.field_22176;
                break;
            }
            case field_11034: {
                class_2754 class_27542 = class_2741.field_22174;
                break;
            }
            case field_11039: {
                class_2754 class_27542 = class_2741.field_22177;
                break;
            }
            default: {
                class_2754 class_27542 = wallProp = null;
            }
        }
        if (wallProp != null && state.method_28498((class_2769)wallProp)) {
            return (class_2680)state.method_11657((class_2769)wallProp, (Comparable)class_4778.field_22179);
        }
        return state;
    }

    private void placeSupport(class_5281 world, class_2338 top) {
        world.method_8652(top, this.baseState, 7);
        class_2338 cur = top.method_10074();
        for (int depth = 0; cur.method_10264() >= world.method_31607() && depth < 3 && !world.method_8320(cur).method_26212((class_1922)world, cur); ++depth) {
            world.method_8652(cur, this.baseState, 7);
            cur = cur.method_10074();
        }
    }

    private class_2338 computeTop(class_5281 world, class_2338 base) {
        int bottomY = world.method_31607();
        boolean baseSolid = world.method_8320(base).method_26212((class_1922)world, base);
        if (!baseSolid) {
            class_2338 probe = base.method_10074();
            for (int depth = 0; probe.method_10264() >= bottomY && depth < 3 && !world.method_8320(probe).method_26212((class_1922)world, probe); ++depth) {
                probe = probe.method_10074();
            }
            if (!world.method_8320(probe).method_26212((class_1922)world, probe)) {
                return null;
            }
            return probe.method_10084();
        }
        class_2338 top = base.method_10084();
        for (int rise = 0; rise < 3 && !world.method_8320(top).method_45474(); ++rise) {
            top = top.method_10084();
        }
        if (!world.method_8320(top).method_45474()) {
            return null;
        }
        class_2338 probe = top.method_10074();
        for (int depth = 0; probe.method_10264() >= bottomY && depth < 3 && !world.method_8320(probe).method_26212((class_1922)world, probe); ++depth) {
            probe = probe.method_10074();
        }
        if (!world.method_8320(probe).method_26212((class_1922)world, probe)) {
            return null;
        }
        return top;
    }
}

