/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.storage;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public final class AddonPersistentStorage
extends SavedData {
    private static final String ROOT = "entries";
    private static final String KEY = "key";
    private static final String VAL = "val";
    private final Map<ResourceLocation, CompoundTag> data = new ConcurrentHashMap<ResourceLocation, CompoundTag>();
    private final ResourceLocation addonId;

    private AddonPersistentStorage() {
        this.addonId = ResourceLocation.m_214293_((String)"roadarchitect", (String)"unknown");
    }

    private AddonPersistentStorage(ResourceLocation addonId) {
        this.addonId = addonId;
    }

    public static AddonPersistentStorage get(ServerLevel world, ResourceLocation addonId) {
        String storageKey = AddonPersistentStorage.storageKey(addonId);
        return PersistentStateUtil.get(world, () -> new AddonPersistentStorage(addonId), tag -> AddonPersistentStorage.fromNbt(tag, addonId), storageKey);
    }

    private static String storageKey(ResourceLocation addonId) {
        String safePath = addonId.m_135815_().replace('/', '_');
        return "ra_addon_" + addonId.m_135827_() + "_" + safePath;
    }

    public static AddonPersistentStorage fromNbt(CompoundTag tag) {
        return AddonPersistentStorage.fromNbt(tag, ResourceLocation.m_214293_((String)"roadarchitect", (String)"unknown"));
    }

    private static AddonPersistentStorage fromNbt(CompoundTag tag, ResourceLocation addonId) {
        AddonPersistentStorage s = new AddonPersistentStorage(addonId);
        ListTag list = tag.m_128437_(ROOT, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag e = list.m_128728_(i);
            ResourceLocation id = ResourceLocation.m_135820_((String)e.m_128461_(KEY));
            if (id == null) continue;
            CompoundTag val = e.m_128469_(VAL);
            s.data.put(id, val.m_6426_());
        }
        return s;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceLocation, CompoundTag> en : this.data.entrySet()) {
            CompoundTag e = new CompoundTag();
            e.m_128359_(KEY, en.getKey().toString());
            e.m_128365_(VAL, (Tag)en.getValue().m_6426_());
            list.add((Object)e);
        }
        tag.m_128365_(ROOT, (Tag)list);
        return tag;
    }

    public Optional<CompoundTag> get(ResourceLocation key) {
        return Optional.ofNullable(this.data.get(key)).map(CompoundTag::m_6426_);
    }

    public void put(ResourceLocation key, CompoundTag value) {
        this.data.put(key, value == null ? new CompoundTag() : value.m_6426_());
    }

    public void remove(ResourceLocation key) {
        this.data.remove(key);
    }

    public Set<ResourceLocation> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }
}

