/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends SavedData {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, Holder<Biome>> biomes = new ConcurrentHashMap<Long, Holder<Biome>>();
    private final ConcurrentMap<Long, String> pendingBiomeIds = new ConcurrentHashMap<Long, String>();

    public static CacheStorage get(ServerLevel world) {
        CacheStorage storage = PersistentStateUtil.get(world, CacheStorage::new, CacheStorage::fromNbt, KEY);
        storage.attachWorld(world.m_9598_());
        return storage;
    }

    public static CacheStorage fromNbt(CompoundTag tag) {
        CacheStorage storage = new CacheStorage();
        ListTag hList = tag.m_128437_(HEIGHTS_KEY, 10);
        NbtUtils.fillLongIntMap(hList, storage.heights);
        ListTag sList = tag.m_128437_(STABILITIES_KEY, 10);
        NbtUtils.fillLongDoubleMap(sList, storage.stabilities);
        ListTag bList = tag.m_128437_(BIOMES_KEY, 10);
        NbtUtils.fillLongStringMap(bList, storage.pendingBiomeIds);
        return storage;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128365_(HEIGHTS_KEY, (Tag)NbtUtils.toLongIntList(this.heights));
        tag.m_128365_(STABILITIES_KEY, (Tag)NbtUtils.toLongDoubleList(this.stabilities));
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(this.biomes.size() + this.pendingBiomeIds.size());
        for (Map.Entry entry : this.biomes.entrySet()) {
            ResourceLocation id = ((Holder)entry.getValue()).m_203543_().map(ResourceKey::m_135782_).orElse(null);
            if (id == null) continue;
            biomeIds.put((Long)entry.getKey(), id.toString());
        }
        this.pendingBiomeIds.forEach(biomeIds::putIfAbsent);
        tag.m_128365_(BIOMES_KEY, (Tag)NbtUtils.toLongStringList(biomeIds));
        return tag;
    }

    public synchronized void attachWorld(RegistryAccess manager) {
        Registry registry = manager.m_175515_(Registries.f_256952_);
        if (registry == null) {
            return;
        }
        Iterator iterator = this.pendingBiomeIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ResourceLocation id = ResourceLocation.m_135820_((String)((String)entry.getValue()));
            if (id == null) continue;
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id);
            registry.m_203636_(key).ifPresent(registryEntry -> this.biomes.put((Long)entry.getKey(), (Holder<Biome>)registryEntry));
            if (!this.biomes.containsKey(entry.getKey())) continue;
            iterator.remove();
        }
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, Holder<Biome>> biomes() {
        return this.biomes;
    }
}

