/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class RoadBuilderStorage
extends SavedData {
    private static final String KEY = "road_builder_tasks";
    private static final String SEGMENTS_KEY = "segments";
    private static final String CHUNK_KEY = "chunk";
    private static final String PATH_KEY = "path";
    private static final String START_KEY = "start";
    private static final String END_KEY = "end";
    private final Map<ChunkPos, List<SegmentEntry>> segments = new ConcurrentHashMap<ChunkPos, List<SegmentEntry>>();

    public static RoadBuilderStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, RoadBuilderStorage::new, RoadBuilderStorage::fromNbt, KEY);
    }

    public static RoadBuilderStorage fromNbt(CompoundTag tag) {
        RoadBuilderStorage storage = new RoadBuilderStorage();
        ListTag list = tag.m_128437_(SEGMENTS_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            ChunkPos chunk = new ChunkPos(entry.m_128454_(CHUNK_KEY));
            String path = entry.m_128461_(PATH_KEY);
            int start = entry.m_128451_(START_KEY);
            int end = entry.m_128451_(END_KEY);
            storage.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(path, start, end));
        }
        return storage;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<ChunkPos, List<SegmentEntry>> entry : this.segments.entrySet()) {
            long pos = entry.getKey().m_45588_();
            for (SegmentEntry segment : entry.getValue()) {
                CompoundTag elem = new CompoundTag();
                elem.m_128356_(CHUNK_KEY, pos);
                elem.m_128359_(PATH_KEY, segment.pathKey());
                elem.m_128405_(START_KEY, segment.start());
                elem.m_128405_(END_KEY, segment.end());
                list.add((Object)elem);
            }
        }
        tag.m_128365_(SEGMENTS_KEY, (Tag)list);
        return tag;
    }

    public void addSegment(ChunkPos chunk, String key, int start, int end) {
        this.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(key, start, end));
        this.m_77762_();
    }

    public List<SegmentEntry> getSegments(ChunkPos chunk) {
        return this.segments.getOrDefault(chunk, List.of());
    }

    public void removeSegment(ChunkPos chunk, SegmentEntry entry) {
        List<SegmentEntry> list = this.segments.get(chunk);
        if (list != null && list.remove(entry)) {
            if (list.isEmpty()) {
                this.segments.remove(chunk);
            }
            this.m_77762_();
        }
    }

    public record SegmentEntry(String pathKey, int start, int end) {
    }
}

