/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.oxcodsnet.roadarchitect.storage.PathDecorStorage;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathDecorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathDecorUtil.class.getSimpleName()));
    public static final byte BOOL_UNKNOWN = 0;
    public static final byte BOOL_TRUE = 1;
    public static final byte BOOL_FALSE = 2;
    private static final int[][] OFFSETS_8 = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    private PathDecorUtil() {
    }

    public static long checksum(List<BlockPos> pts) {
        long h = 1469598103934665603L;
        for (BlockPos p : pts) {
            long v = p.m_121878_();
            h ^= v;
            h *= 1099511628211L;
        }
        return h;
    }

    public static double[] computePrefix(List<BlockPos> pts) {
        int n = pts.size();
        double[] S = new double[n];
        for (int i = 1; i < n; ++i) {
            BlockPos a = pts.get(i - 1);
            BlockPos b = pts.get(i);
            S[i] = S[i - 1] + Math.hypot(b.m_123341_() - a.m_123341_(), b.m_123343_() - a.m_123343_());
        }
        return S;
    }

    public static double[] ensurePrefix(PathDecorStorage storage, String pathKey, List<BlockPos> pts) {
        long sum = PathDecorUtil.checksum(pts);
        double[] S = storage.getPrefix(pathKey);
        if (S == null || S.length != pts.size() || storage.getChecksum(pathKey) != sum) {
            S = PathDecorUtil.computePrefix(pts);
            storage.ensureCapacity(pathKey, pts.size());
            storage.setPrefix(pathKey, S);
            storage.updateChecksum(pathKey, sum);
            storage.clearMasks(pathKey);
            DebugLog.info(LOGGER, "Refreshed prefix S for {} ({} points)", pathKey, pts.size());
        }
        return S;
    }

    public static int phaseFor(String pathKey, int step) {
        if (step <= 0) {
            return 0;
        }
        int hash = pathKey.hashCode();
        return Math.floorMod(hash, step);
    }

    public static int lowerBound(double[] S, int from, int to, double x) {
        int lo = Math.max(0, from);
        int hi = Math.max(lo, Math.min(S.length, to));
        while (lo < hi) {
            int mid = lo + hi >>> 1;
            if (S[mid] < x) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return lo;
    }

    public static long[] kRange(double sFrom, double sTo, int step, int phase) {
        if (step <= 0 || sTo <= sFrom) {
            return new long[]{1L, 0L};
        }
        double a = (sFrom - (double)phase) / (double)step;
        double b = (sTo - (double)phase) / (double)step;
        long kMin = (long)Math.ceil(a);
        long kMax = (long)Math.floor(Math.nextDown(b));
        return new long[]{kMin, kMax};
    }

    public static void fillGroundMask(PathDecorStorage storage, String key, WorldGenLevel world, List<BlockPos> pts, int from, int to) {
        byte[] mask = storage.getGroundMask(key);
        if (mask == null) {
            return;
        }
        int n = Math.min(mask.length, pts.size());
        int s = Math.max(0, from);
        int e = Math.min(n, to);
        for (int i = s; i < e; ++i) {
            if (mask[i] != 0) continue;
            mask[i] = PathDecorUtil.safeIsNotWaterBlock(world, pts.get(i)) ? 1 : 2;
        }
        storage.touch();
    }

    public static void fillWaterInteriorMask(PathDecorStorage storage, String key, WorldGenLevel world, List<BlockPos> pts, int from, int to) {
        byte[] mask = storage.getWaterInteriorMask(key);
        if (mask == null) {
            return;
        }
        int n = Math.min(mask.length, pts.size());
        int s = Math.max(0, from);
        int e = Math.min(n, to);
        for (int i = s; i < e; ++i) {
            if (mask[i] != 0) continue;
            BlockPos p = pts.get(i);
            if (PathDecorUtil.safeIsNotWaterBlock(world, p)) {
                mask[i] = 2;
                continue;
            }
            boolean interior = true;
            for (int[] d : OFFSETS_8) {
                BlockPos q = p.m_7918_(d[0], 0, d[1]);
                if (!PathDecorUtil.safeIsNotWaterBlock(world, q)) continue;
                interior = false;
                break;
            }
            mask[i] = interior ? 1 : 2;
        }
        storage.touch();
    }

    public static boolean safeIsNotWaterBlock(WorldGenLevel world, BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!world.m_7232_(cp.f_45578_, cp.f_45579_)) {
            return true;
        }
        return !world.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public static boolean erodedAccept(byte[] mask, int i, int E, byte want) {
        if (mask == null || i < 0 || i >= mask.length) {
            return false;
        }
        if (mask[i] != want) {
            return false;
        }
        if (E <= 0) {
            return true;
        }
        for (int d = 1; d <= E; ++d) {
            int l = i - d;
            int r = i + d;
            if (l < 0 || r >= mask.length) {
                return false;
            }
            if (mask[l] == want && mask[r] == want) continue;
            return false;
        }
        return true;
    }

    public static List<Marker> markersInWindow(double[] S, int from, int to, int step, int phase) {
        long kMin;
        double sTo;
        ArrayList<Marker> out = new ArrayList<Marker>();
        if (S == null || S.length == 0 || step <= 0 || to <= from) {
            return out;
        }
        double sFrom = S[Math.max(0, from)];
        long[] kr = PathDecorUtil.kRange(sFrom, sTo = S[Math.max(0, Math.min(to - 1, S.length - 1))], step, phase);
        long kMax = kr[1];
        if (kMax < (kMin = kr[0])) {
            return out;
        }
        for (long k = kMin; k <= kMax; ++k) {
            double m = (double)phase + (double)k * (double)step;
            int i = PathDecorUtil.lowerBound(S, from, to, m);
            if (i < from || i >= to) continue;
            out.add(new Marker(i, k));
        }
        return out;
    }

    public static boolean detBool(String pathKey, long ordinal) {
        long seed = -7046029254386353131L * (long)pathKey.hashCode() + (ordinal << 1) + 7146057691288625177L;
        seed ^= seed >>> 33;
        seed *= -49064778989728563L;
        return ((seed ^= seed >>> 33) & 1L) == 1L;
    }

    public static int detInt(String pathKey, long ordinal, int bound) {
        if (bound <= 1) {
            return 0;
        }
        long seed = -7046029254386353131L * (long)pathKey.hashCode() + ordinal * -7046029254386353131L;
        seed ^= seed >>> 33;
        seed *= -4265267296055464877L;
        seed ^= seed >>> 33;
        int v = (int)(seed ^ seed >>> 32);
        return Math.floorMod(v, bound);
    }

    public record Marker(int index, long k) {
    }
}

