/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class FenceDecoration
implements Decoration {
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int PLACE_FLAGS = 7;
    private final BlockState fenceState;

    public FenceDecoration(BlockState fenceState) {
        this.fenceState = fenceState;
    }

    @Override
    public void place(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        BlockPos top = this.computeTop(world, basePos);
        if (top == null) {
            return;
        }
        this.placeFromTopDown(world, top);
    }

    private BlockPos computeTop(WorldGenLevel world, BlockPos base) {
        int bottomY = world.m_141937_();
        BlockState baseState = world.m_8055_(base);
        boolean baseSolid = baseState.m_60796_((BlockGetter)world, base);
        if (!baseSolid) {
            BlockPos probe = base.m_7495_();
            for (int depth = 0; probe.m_123342_() >= bottomY && depth < 3 && !world.m_8055_(probe).m_60796_((BlockGetter)world, probe); ++depth) {
                probe = probe.m_7495_();
            }
            if (!world.m_8055_(probe).m_60796_((BlockGetter)world, probe)) {
                return null;
            }
            BlockPos top = probe.m_7494_();
            if (!world.m_8055_(top).m_247087_()) {
                return null;
            }
            return top;
        }
        BlockPos top = base.m_7494_();
        for (int rise = 0; rise < 3 && !world.m_8055_(top).m_247087_(); ++rise) {
            top = top.m_7494_();
        }
        if (!world.m_8055_(top).m_247087_()) {
            return null;
        }
        BlockPos probe = top.m_7495_();
        for (int depth = 0; probe.m_123342_() >= bottomY && depth < 3 && !world.m_8055_(probe).m_60796_((BlockGetter)world, probe); ++depth) {
            probe = probe.m_7495_();
        }
        if (!world.m_8055_(probe).m_60796_((BlockGetter)world, probe)) {
            return null;
        }
        return top;
    }

    private void placeFromTopDown(WorldGenLevel world, BlockPos top) {
        world.m_7731_(top, this.fenceState, 7);
        BlockPos cur = top.m_7495_();
        for (int depth = 0; cur.m_123342_() >= world.m_141937_() && depth < 3 && !world.m_8055_(cur).m_60796_((BlockGetter)world, cur); ++depth) {
            world.m_7731_(cur, this.fenceState, 7);
            cur = cur.m_7495_();
        }
    }

    public void placeFenceStripe(WorldGenLevel world, List<BlockPos> stripe) {
        for (BlockPos base : stripe) {
            BlockPos top = this.computeTop(world, base);
            if (top == null) continue;
            this.placeFromTopDown(world, top);
        }
        for (BlockPos base : stripe) {
            for (int dy = 0; dy <= 3; ++dy) {
                BlockPos p = base.m_6630_(dy);
                BlockState st = world.m_8055_(p);
                if (!st.m_60713_(this.fenceState.m_60734_())) continue;
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    BlockPos n = p.m_121945_(d);
                    st = st.m_60728_(d, world.m_8055_(n), (LevelAccessor)world, p, n);
                }
                world.m_7731_(p, st, 7);
            }
        }
    }
}

