/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.api.core.BuildQueueView;
import net.oxcodsnet.roadarchitect.api.core.BuildSegment;
import net.oxcodsnet.roadarchitect.api.core.CoreApi;
import net.oxcodsnet.roadarchitect.api.core.DecorView;
import net.oxcodsnet.roadarchitect.api.core.EdgeStatus;
import net.oxcodsnet.roadarchitect.api.core.EdgeView;
import net.oxcodsnet.roadarchitect.api.core.NodeView;
import net.oxcodsnet.roadarchitect.api.core.PathStatus;
import net.oxcodsnet.roadarchitect.api.core.PathView;
import net.oxcodsnet.roadarchitect.api.core.RoadGraphView;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.PathDecorStorage;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public final class CoreApiImpl
implements CoreApi {
    public static final CoreApi INSTANCE = new CoreApiImpl();

    private CoreApiImpl() {
    }

    @Override
    public RoadGraphView graph(class_3218 world) {
        final RoadGraphState state = RoadGraphState.get(world);
        return new RoadGraphView(){

            @Override
            public Map<String, NodeView> nodes() {
                HashMap<String, NodeView> out = new HashMap<String, NodeView>();
                for (Map.Entry<String, Node> e : state.nodes().all().entrySet()) {
                    out.put(e.getKey(), new NodeView(e.getKey(), e.getValue().pos(), e.getValue().type()));
                }
                return Collections.unmodifiableMap(out);
            }

            @Override
            public Map<String, EdgeView> edges() {
                HashMap<String, EdgeView> out = new HashMap<String, EdgeView>();
                for (Map.Entry<String, EdgeStorage.Edge> e : state.edges().all().entrySet()) {
                    out.put(e.getKey(), new EdgeView(e.getKey(), e.getValue().nodeA(), e.getValue().nodeB(), CoreApiImpl.toEdgeStatus(e.getValue().status())));
                }
                return Collections.unmodifiableMap(out);
            }

            @Override
            public Set<String> neighbors(String nodeId) {
                return Set.copyOf(state.edges().neighbors(nodeId));
            }

            @Override
            public Optional<NodeView> node(String id) {
                Node n = state.nodes().all().get(id);
                if (n == null) {
                    return Optional.empty();
                }
                return Optional.of(new NodeView(id, n.pos(), n.type()));
            }

            @Override
            public Optional<NodeView> nearest(class_2338 pos, double maxDistance) {
                double max2 = maxDistance * maxDistance;
                String bestId = null;
                Node best = null;
                double bestD = Double.MAX_VALUE;
                for (Map.Entry<String, Node> e : state.nodes().all().entrySet()) {
                    double dz;
                    class_2338 p = e.getValue().pos();
                    double dx = p.method_10263() - pos.method_10263();
                    double d2 = dx * dx + (dz = (double)(p.method_10260() - pos.method_10260())) * dz;
                    if (!(d2 <= max2) || !(d2 < bestD)) continue;
                    bestD = d2;
                    bestId = e.getKey();
                    best = e.getValue();
                }
                if (best == null) {
                    return Optional.empty();
                }
                return Optional.of(new NodeView(bestId, best.pos(), best.type()));
            }
        };
    }

    @Override
    public PathView paths(class_3218 world) {
        final PathStorage ps = PathStorage.get(world);
        return new PathView(){

            @Override
            public List<class_2338> path(String key) {
                return List.copyOf(ps.getPath(key));
            }

            @Override
            public PathStatus status(String key) {
                return CoreApiImpl.toPathStatus(ps.getStatus(key));
            }

            @Override
            public Map<String, PathStatus> allStatuses() {
                Map<String, PathStorage.Status> src = ps.allStatuses();
                HashMap<String, PathStatus> out = new HashMap<String, PathStatus>();
                for (Map.Entry<String, PathStorage.Status> e : src.entrySet()) {
                    out.put(e.getKey(), CoreApiImpl.toPathStatus(e.getValue()));
                }
                return Collections.unmodifiableMap(out);
            }

            @Override
            public List<String> pendingForChunk(class_1923 chunk) {
                return List.copyOf(ps.getPendingForChunk(chunk));
            }
        };
    }

    @Override
    public BuildQueueView buildQueue(class_3218 world) {
        RoadBuilderStorage rbs = RoadBuilderStorage.get(world);
        return chunk -> {
            ArrayList<BuildSegment> out = new ArrayList<BuildSegment>();
            for (RoadBuilderStorage.SegmentEntry s : rbs.getSegments(chunk)) {
                out.add(new BuildSegment(s.pathKey(), s.start(), s.end()));
            }
            return List.copyOf(out);
        };
    }

    @Override
    public DecorView decor(class_3218 world) {
        final PathDecorStorage ds = PathDecorStorage.get(world);
        return new DecorView(){

            @Override
            public long checksum(String pathKey) {
                return ds.getChecksum(pathKey);
            }

            @Override
            public double[] prefix(String pathKey) {
                double[] in = ds.getPrefix(pathKey);
                return in == null ? new double[]{} : Arrays.copyOf(in, in.length);
            }

            @Override
            public byte[] groundMask(String pathKey) {
                byte[] in = ds.getGroundMask(pathKey);
                return in == null ? new byte[]{} : Arrays.copyOf(in, in.length);
            }

            @Override
            public byte[] waterInteriorMask(String pathKey) {
                byte[] in = ds.getWaterInteriorMask(pathKey);
                return in == null ? new byte[]{} : Arrays.copyOf(in, in.length);
            }
        };
    }

    private static EdgeStatus toEdgeStatus(EdgeStorage.Status s) {
        return switch (s) {
            default -> throw new IncompatibleClassChangeError();
            case EdgeStorage.Status.NEW -> EdgeStatus.NEW;
            case EdgeStorage.Status.SUCCESS -> EdgeStatus.SUCCESS;
            case EdgeStorage.Status.FAILURE -> EdgeStatus.FAILURE;
        };
    }

    private static PathStatus toPathStatus(PathStorage.Status s) {
        return switch (s) {
            default -> throw new IncompatibleClassChangeError();
            case PathStorage.Status.PENDING -> PathStatus.PENDING;
            case PathStorage.Status.PROCESSING -> PathStatus.PROCESSING;
            case PathStorage.Status.READY -> PathStatus.READY;
            case PathStorage.Status.FAILED -> PathStatus.FAILED;
        };
    }
}

