/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class RoadGraphDebugScreenVanilla
extends class_437 {
    private static final int RADIUS = 4;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private final List<DimensionLayer> layers;
    private final Supplier<class_2561> titleSupplier;
    private final Map<String, ScreenPos> screenPositions = new HashMap<String, ScreenPos>();
    private final Map<String, Integer> typeColors = new HashMap<String, Integer>();
    private final Map<EdgeStorage.Status, Integer> statusColors = Map.of(EdgeStorage.Status.NEW, -865972, EdgeStorage.Status.SUCCESS, -14176672, EdgeStorage.Status.FAILURE, -5368277);
    private final Map<class_5321<class_1937>, ViewState> viewStates = new HashMap<class_5321<class_1937>, ViewState>();
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<EdgeStorage.Edge> edges = new ArrayList<EdgeStorage.Edge>();
    private final Set<String> currentTypes = new LinkedHashSet<String>();
    private DimensionLayer currentLayer;
    private class_5321<class_1937> lastPlayerDimension;
    private boolean dragging = false;
    private boolean firstLayout = true;
    private double zoom = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;

    public RoadGraphDebugScreenVanilla(List<DimensionLayer> layers) {
        this(layers, () -> class_2561.method_43470((String)"Road Graph Debug"));
    }

    public RoadGraphDebugScreenVanilla(List<DimensionLayer> layers, Supplier<class_2561> titleSupplier) {
        super(titleSupplier.get());
        this.layers = List.copyOf(layers);
        this.titleSupplier = titleSupplier;
        for (DimensionLayer layer : this.layers) {
            for (Node node : layer.nodes()) {
                this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
            }
        }
        if (this.layers.isEmpty()) {
            this.recalcBounds();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.focusOnCurrentDimension();
    }

    public void method_25410(class_310 client, int width, int height) {
        this.saveCurrentViewState();
        super.method_25410(client, width, height);
        if (this.currentLayer != null) {
            this.loadViewState(this.currentLayer);
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.focusOnCurrentDimension();
        this.computeLayout();
        ctx.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -1609560048);
        ctx.method_49601(20, 20, this.field_22789 - 40, this.field_22790 - 40, -1);
        this.drawGrid(ctx);
        for (EdgeStorage.Edge edge : this.edges) {
            ScreenPos a = this.screenPositions.get(edge.nodeA());
            ScreenPos b = this.screenPositions.get(edge.nodeB());
            if (a == null || b == null) continue;
            int col = this.statusColors.getOrDefault((Object)edge.status(), -1);
            RoadGraphDebugScreenVanilla.drawLine(ctx, a.x, a.y, b.x, b.y, col);
        }
        Node hovered = null;
        for (Node n : this.nodes) {
            ScreenPos p = this.screenPositions.get(n.id());
            if (p == null) continue;
            int fill = this.typeColors.getOrDefault(n.type(), -1);
            RoadGraphDebugScreenVanilla.fillCircle(ctx, p.x, p.y, 4, fill);
            RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, p.x, p.y, 4, -16777216);
            if (!(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            hovered = n;
        }
        if (hovered != null) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            ctx.method_51438(class_3272, (class_2561)class_2561.method_43470((String)(hovered.pos().method_23854() + " \u2022 " + hovered.type())), mouseX, mouseY);
        }
        this.drawPlayerMarker(ctx);
        this.drawScale(ctx);
        this.drawLegend(ctx);
        this.drawDimensionLabel(ctx);
        this.drawCenteredTitle(ctx);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    public void method_25432() {
        this.saveCurrentViewState();
        super.method_25432();
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        Node clicked = this.findClickedNode(mouseX, mouseY);
        if (clicked != null) {
            return this.teleportTo(clicked);
        }
        this.dragging = true;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            this.firstLayout = false;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        double old = this.zoom;
        if (amount == 0.0) {
            return false;
        }
        this.zoom = amount > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.firstLayout = false;
        return true;
    }

    private void drawCenteredTitle(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        class_2561 t = this.titleSupplier.get();
        int tw = font.method_27525((class_5348)t);
        ctx.method_51439(font, t, (this.field_22789 - tw) / 2, 8, -1, true);
    }

    private void drawGrid(class_332 ctx) {
        if (this.nodes.isEmpty()) {
            return;
        }
        int w = this.field_22789 - 40;
        int h = this.field_22790 - 40;
        double worldX0 = (double)this.minX + -this.offsetX / (this.baseScale * this.zoom);
        double worldZ0 = (double)this.minZ + -this.offsetY / (this.baseScale * this.zoom);
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / (this.baseScale * this.zoom);
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / (this.baseScale * this.zoom);
        int spacing = this.computeGridSpacing();
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int x = startWX;
        while ((double)x <= worldX1) {
            int sx = 20 + (int)(((double)x - worldX0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillV(ctx, sx, 20, 20 + h, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(x), sx + 2, 22);
            x += spacing;
        }
        int z = startWZ;
        while ((double)z <= worldZ1) {
            int sz = 20 + (int)(((double)z - worldZ0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillH(ctx, 20, 20 + w, sz, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(z), 22, sz + 2);
            z += spacing;
        }
    }

    private void drawScale(class_332 ctx) {
        if (this.nodes.isEmpty()) {
            return;
        }
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)((double)spacing * this.baseScale * this.zoom);
        int x = this.field_22789 - 20 - lengthPx - 10;
        int y = this.field_22790 - 20 - 8;
        RoadGraphDebugScreenVanilla.fillH(ctx, x, x + lengthPx, y, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x, y - 3, y + 3, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x + lengthPx, y - 3, y + 3, -1);
        this.drawSmallLabel(ctx, spacing + "m", x, y - 10);
    }

    private void drawLegend(class_332 ctx) {
        if (this.currentTypes.isEmpty()) {
            return;
        }
        int x = 20;
        int y = this.field_22790 - 20 - this.currentTypes.size() * 12;
        for (String type : this.currentTypes) {
            int color = this.typeColors.getOrDefault(type, -1);
            ctx.method_25294(x, y, x + 8, y + 8, color);
            ctx.method_49601(x, y, 8, 8, -1);
            this.drawSmallLabel(ctx, type, x + 10, y);
            y += 12;
        }
    }

    private void drawDimensionLabel(class_332 ctx) {
        if (this.currentLayer == null) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        String dimName = RoadGraphDebugScreenVanilla.describeLayer(this.currentLayer).getString();
        class_5250 label = class_2561.method_43469((String)"screen.roadarchitect.debug.dimension_label", (Object[])new Object[]{dimName}).method_27692(class_124.field_1080);
        ctx.method_51439(font, (class_2561)label, 24, 24, -5592406, false);
    }

    private void computeLayout() {
        if (this.nodes.isEmpty()) {
            return;
        }
        int w = Math.max(1, this.field_22789 - 40);
        int h = Math.max(1, this.field_22790 - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ);
        if (this.firstLayout) {
            double graphW = (double)(this.maxX - this.minX) * this.baseScale * this.zoom;
            double graphH = (double)(this.maxZ - this.minZ) * this.baseScale * this.zoom;
            this.offsetX = ((double)w - graphW) / 2.0;
            this.offsetY = ((double)h - graphH) / 2.0;
            this.firstLayout = false;
        }
        this.screenPositions.clear();
        for (Node node : this.nodes) {
            double sx = (double)(node.pos().method_10263() - this.minX) * this.baseScale * this.zoom + this.offsetX;
            double sy = (double)(node.pos().method_10260() - this.minZ) * this.baseScale * this.zoom + this.offsetY;
            this.screenPositions.put(node.id(), new ScreenPos(20 + (int)sx, 20 + (int)sy));
        }
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private Node findClickedNode(double mouseX, double mouseY) {
        for (Node node : this.nodes) {
            ScreenPos p = this.screenPositions.get(node.id());
            if (p == null || !(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            return node;
        }
        return null;
    }

    private boolean teleportTo(Node node) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return false;
        }
        if (this.currentLayer == null || !Objects.equals(mc.field_1687.method_27983(), this.currentLayer.dimension())) {
            return false;
        }
        if (mc.method_1576() != null) {
            mc.method_1576().execute(() -> {
                class_3222 sp = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667());
                if (sp != null) {
                    sp.method_5859((double)node.pos().method_10263() + 0.5, (double)node.pos().method_10264(), (double)node.pos().method_10260() + 0.5);
                }
            });
            return true;
        }
        return false;
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private void drawSmallLabel(class_332 ctx, String s, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        ctx.method_51439(font, (class_2561)class_2561.method_43470((String)s), x, y, -1, true);
    }

    private static void fillH(class_332 ctx, int x0, int x1, int y, int argb) {
        if (x1 < x0) {
            int t = x0;
            x0 = x1;
            x1 = t;
        }
        ctx.method_25294(x0, y, x1, y + 1, argb);
    }

    private static void fillV(class_332 ctx, int x, int y0, int y1, int argb) {
        if (y1 < y0) {
            int t = y0;
            y0 = y1;
            y1 = t;
        }
        ctx.method_25294(x, y0, x + 1, y1, argb);
    }

    private static void drawLine(class_332 ctx, int x0, int y0, int x1, int y1, int argb) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            ctx.method_25294(x, y, x + 1, y + 1, argb);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static void fillCircle(class_332 ctx, int cx, int cy, int r, int argb) {
        for (int dy = -r; dy <= r; ++dy) {
            int span = (int)Math.round(Math.sqrt(r * r - dy * dy));
            ctx.method_25294(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
        }
    }

    private static void drawCircleOutline(class_332 ctx, int cx, int cy, int r, int argb) {
        int x = r;
        int y = 0;
        int err = 0;
        while (x >= y) {
            RoadGraphDebugScreenVanilla.plot8(ctx, cx, cy, x, y, argb);
            ++y;
            if (err <= 0) {
                err += 2 * y + 1;
            }
            if (err <= 0) continue;
            err -= 2 * --x + 1;
        }
    }

    private static void plot8(class_332 ctx, int cx, int cy, int x, int y, int argb) {
        ctx.method_25294(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
        ctx.method_25294(cx + y, cy + x, cx + y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - y, cy + x, cx - y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - x, cy + y, cx - x + 1, cy + y + 1, argb);
        ctx.method_25294(cx - x, cy - y, cx - x + 1, cy - y + 1, argb);
        ctx.method_25294(cx - y, cy - x, cx - y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + y, cy - x, cx + y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + x, cy - y, cx + x + 1, cy - y + 1, argb);
    }

    private static int hsvToArgb(float hDeg, float s, float v) {
        float h = (hDeg % 360.0f + 360.0f) % 360.0f / 60.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case -1: 
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }

    private ScreenPos worldToScreen(double wx, double wz) {
        int sx = 20 + (int)((wx - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int sy = 20 + (int)((wz - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(sx, sy);
    }

    private void drawPlayerMarker(class_332 ctx) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (this.currentLayer == null || !Objects.equals(mc.field_1687.method_27983(), this.currentLayer.dimension())) {
            return;
        }
        if (this.nodes.isEmpty()) {
            return;
        }
        double px = mc.field_1724.method_23317();
        double pz = mc.field_1724.method_23321();
        ScreenPos p = this.worldToScreen(px, pz);
        int r = 6;
        int fill = -1618884;
        int outline = -16777216;
        RoadGraphDebugScreenVanilla.fillCircle(ctx, p.x, p.y, 6, -1618884);
        RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, p.x, p.y, 6, -16777216);
        float yaw = mc.field_1724.method_36454();
        double a = Math.toRadians(yaw) + 1.5707963267948966;
        int tx = p.x + (int)Math.round(Math.cos(a) * 9.0);
        int ty = p.y + (int)Math.round(Math.sin(a) * 9.0);
        RoadGraphDebugScreenVanilla.drawLine(ctx, p.x, p.y, tx, ty, -1);
    }

    private void setActiveLayer(int index) {
        if (this.layers.isEmpty()) {
            this.currentLayer = null;
            this.nodes.clear();
            this.edges.clear();
            this.currentTypes.clear();
            this.recalcBounds();
            return;
        }
        this.saveCurrentViewState();
        int normalized = Math.floorMod(index, this.layers.size());
        this.currentLayer = this.layers.get(normalized);
        this.nodes.clear();
        this.nodes.addAll(this.currentLayer.nodes());
        this.edges.clear();
        this.edges.addAll(this.currentLayer.edges());
        this.currentTypes.clear();
        for (Node node : this.nodes) {
            this.currentTypes.add(node.type());
            this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
        }
        this.recalcBounds();
        this.loadViewState(this.currentLayer);
        this.screenPositions.clear();
        this.lastPlayerDimension = this.currentLayer.dimension();
    }

    private void clearActiveLayer() {
        this.saveCurrentViewState();
        if (this.currentLayer == null && this.nodes.isEmpty() && this.edges.isEmpty()) {
            return;
        }
        this.currentLayer = null;
        this.nodes.clear();
        this.edges.clear();
        this.currentTypes.clear();
        this.recalcBounds();
        this.screenPositions.clear();
        this.zoom = 1.0;
        this.offsetX = 0.0;
        this.offsetY = 0.0;
        this.baseScale = 1.0;
        this.firstLayout = true;
    }

    private void focusOnCurrentDimension() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            if (this.currentLayer != null) {
                this.clearActiveLayer();
            }
            this.lastPlayerDimension = null;
            return;
        }
        class_5321 playerDimension = mc.field_1687.method_27983();
        if (this.currentLayer != null && Objects.equals(this.currentLayer.dimension(), playerDimension)) {
            this.lastPlayerDimension = playerDimension;
            return;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            DimensionLayer layer = this.layers.get(i);
            if (!Objects.equals(layer.dimension(), playerDimension)) continue;
            this.setActiveLayer(i);
            this.lastPlayerDimension = playerDimension;
            return;
        }
        if (this.currentLayer != null || !Objects.equals(this.lastPlayerDimension, playerDimension)) {
            this.clearActiveLayer();
        }
        this.lastPlayerDimension = playerDimension;
    }

    private void recalcBounds() {
        if (this.nodes.isEmpty()) {
            this.maxZ = 0;
            this.minZ = 0;
            this.maxX = 0;
            this.minX = 0;
            return;
        }
        this.minX = this.nodes.stream().mapToInt(n -> n.pos().method_10263()).min().orElse(0);
        this.maxX = this.nodes.stream().mapToInt(n -> n.pos().method_10263()).max().orElse(0);
        this.minZ = this.nodes.stream().mapToInt(n -> n.pos().method_10260()).min().orElse(0);
        this.maxZ = this.nodes.stream().mapToInt(n -> n.pos().method_10260()).max().orElse(0);
    }

    private void saveCurrentViewState() {
        if (this.currentLayer == null) {
            return;
        }
        this.viewStates.put(this.currentLayer.dimension(), new ViewState(this.zoom, this.offsetX, this.offsetY, this.firstLayout));
    }

    private void loadViewState(DimensionLayer layer) {
        ViewState state = this.viewStates.get(layer.dimension());
        if (state != null) {
            this.zoom = state.zoom();
            this.offsetX = state.offsetX();
            this.offsetY = state.offsetY();
            this.firstLayout = state.firstLayout();
        } else {
            this.zoom = 1.0;
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.firstLayout = true;
        }
    }

    private static class_2561 describeLayer(DimensionLayer layer) {
        class_2960 id = layer.dimension().method_29177();
        return class_2561.method_43470((String)id.toString());
    }

    public record DimensionLayer(class_5321<class_1937> dimension, List<Node> nodes, List<EdgeStorage.Edge> edges) {
        public DimensionLayer {
            nodes = List.copyOf(nodes);
            edges = List.copyOf(edges);
        }
    }

    private record ScreenPos(int x, int y) {
    }

    private record ViewState(double zoom, double offsetX, double offsetY, boolean firstLayout) {
    }
}

