/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends class_18 {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, class_6880<class_1959>> biomes = new ConcurrentHashMap<Long, class_6880<class_1959>>();
    private final ConcurrentMap<Long, String> pendingBiomeIds = new ConcurrentHashMap<Long, String>();

    public static CacheStorage get(class_3218 world) {
        CacheStorage storage = PersistentStateUtil.get(world, CacheStorage::new, CacheStorage::fromNbt, KEY);
        storage.attachWorld(world.method_30349());
        return storage;
    }

    public static CacheStorage fromNbt(class_2487 tag) {
        CacheStorage storage = new CacheStorage();
        class_2499 hList = tag.method_10554(HEIGHTS_KEY, 10);
        NbtUtils.fillLongIntMap(hList, storage.heights);
        class_2499 sList = tag.method_10554(STABILITIES_KEY, 10);
        NbtUtils.fillLongDoubleMap(sList, storage.stabilities);
        class_2499 bList = tag.method_10554(BIOMES_KEY, 10);
        NbtUtils.fillLongStringMap(bList, storage.pendingBiomeIds);
        return storage;
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10566(HEIGHTS_KEY, (class_2520)NbtUtils.toLongIntList(this.heights));
        tag.method_10566(STABILITIES_KEY, (class_2520)NbtUtils.toLongDoubleList(this.stabilities));
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(this.biomes.size() + this.pendingBiomeIds.size());
        for (Map.Entry entry : this.biomes.entrySet()) {
            class_2960 id = ((class_6880)entry.getValue()).method_40230().map(class_5321::method_29177).orElse(null);
            if (id == null) continue;
            biomeIds.put((Long)entry.getKey(), id.toString());
        }
        this.pendingBiomeIds.forEach(biomeIds::putIfAbsent);
        tag.method_10566(BIOMES_KEY, (class_2520)NbtUtils.toLongStringList(biomeIds));
        return tag;
    }

    public synchronized void attachWorld(class_5455 manager) {
        class_2378 registry = manager.method_30530(class_7924.field_41236);
        if (registry == null) {
            return;
        }
        Iterator iterator = this.pendingBiomeIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            class_2960 id = class_2960.method_12829((String)((String)entry.getValue()));
            if (id == null) continue;
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
            registry.method_40264(key).ifPresent(registryEntry -> this.biomes.put((Long)entry.getKey(), (class_6880<class_1959>)registryEntry));
            if (!this.biomes.containsKey(entry.getKey())) continue;
            iterator.remove();
        }
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, class_6880<class_1959>> biomes() {
        return this.biomes;
    }
}

