/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathDecorStorage
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathDecorStorage.class.getSimpleName()));
    private static final String KEY = "road_path_decor";
    private static final String ENTRIES_KEY = "entries";
    private static final String PATH_KEY = "path";
    private static final String CHECKSUM_KEY = "sum";
    private static final String PREFIX_KEY = "S";
    private static final String GROUND_KEY = "G";
    private static final String WATER_INNER_KEY = "W";
    private final ConcurrentMap<String, double[]> prefix = new ConcurrentHashMap<String, double[]>();
    private final ConcurrentMap<String, byte[]> groundMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, byte[]> waterInteriorMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, Long> checksums = new ConcurrentHashMap<String, Long>();

    public static PathDecorStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, PathDecorStorage::new, PathDecorStorage::fromNbt, KEY);
    }

    public static PathDecorStorage fromNbt(class_2487 tag) {
        PathDecorStorage storage = new PathDecorStorage();
        class_2499 list = tag.method_10554(ENTRIES_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 e = list.method_10602(i);
            String key = e.method_10558(PATH_KEY);
            long sum = e.method_10537(CHECKSUM_KEY);
            storage.checksums.put(key, sum);
            class_2499 sList = e.method_10554(PREFIX_KEY, 8);
            double[] S = new double[sList.size()];
            for (int j = 0; j < sList.size(); ++j) {
                S[j] = Double.parseDouble(sList.method_10608(j));
            }
            storage.prefix.put(key, S);
            storage.groundMask.put(key, PathDecorStorage.getByteArray(e, GROUND_KEY));
            storage.waterInteriorMask.put(key, PathDecorStorage.getByteArray(e, WATER_INNER_KEY));
        }
        return storage;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 out = new class_2499();
        for (Map.Entry e : this.prefix.entrySet()) {
            double[] S;
            String key = (String)e.getKey();
            class_2487 obj = new class_2487();
            obj.method_10582(PATH_KEY, key);
            obj.method_10544(CHECKSUM_KEY, this.checksums.getOrDefault(key, 0L).longValue());
            class_2499 sList = new class_2499();
            for (double v : S = (double[])e.getValue()) {
                sList.add((Object)class_2519.method_23256((String)Double.toString(v)));
            }
            obj.method_10566(PREFIX_KEY, (class_2520)sList);
            PathDecorStorage.putByteArray(obj, GROUND_KEY, (byte[])this.groundMask.get(key));
            PathDecorStorage.putByteArray(obj, WATER_INNER_KEY, (byte[])this.waterInteriorMask.get(key));
            out.add((Object)obj);
        }
        tag.method_10566(ENTRIES_KEY, (class_2520)out);
        return tag;
    }

    public double[] getPrefix(String pathKey) {
        return (double[])this.prefix.get(pathKey);
    }

    public byte[] getGroundMask(String pathKey) {
        return (byte[])this.groundMask.get(pathKey);
    }

    public byte[] getWaterInteriorMask(String pathKey) {
        return (byte[])this.waterInteriorMask.get(pathKey);
    }

    public long getChecksum(String pathKey) {
        return this.checksums.getOrDefault(pathKey, 0L);
    }

    public void ensureCapacity(String pathKey, int n) {
        double[] S = (double[])this.prefix.get(pathKey);
        if (S == null || S.length != n) {
            this.prefix.put(pathKey, new double[n]);
            this.groundMask.put(pathKey, new byte[n]);
            this.waterInteriorMask.put(pathKey, new byte[n]);
            this.method_80();
        }
    }

    public void updateChecksum(String pathKey, long sum) {
        Long prev = this.checksums.put(pathKey, sum);
        if (prev == null || prev != sum) {
            this.method_80();
        }
    }

    public void setPrefix(String pathKey, double[] S) {
        this.prefix.put(pathKey, S);
        this.method_80();
    }

    public void clearMasks(String pathKey) {
        byte[] g = (byte[])this.groundMask.get(pathKey);
        byte[] w = (byte[])this.waterInteriorMask.get(pathKey);
        if (g != null) {
            Arrays.fill(g, (byte)0);
        }
        if (w != null) {
            Arrays.fill(w, (byte)0);
        }
        this.method_80();
    }

    public void touch() {
        this.method_80();
    }

    private static byte[] getByteArray(class_2487 obj, String key) {
        class_2499 list = obj.method_10554(key, 8);
        byte[] arr = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = Byte.parseByte(list.method_10608(i));
        }
        return arr;
    }

    private static void putByteArray(class_2487 obj, String key, byte[] arr) {
        class_2499 list = new class_2499();
        if (arr != null) {
            for (byte b : arr) {
                list.add((Object)class_2519.method_23256((String)Byte.toString(b)));
            }
        }
        obj.method_10566(key, (class_2520)list);
    }
}

