/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.util.KeyUtil;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathStorage
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathStorage.class.getSimpleName()));
    private static final String KEY = "road_paths";
    private static final String PATHS_KEY = "paths";
    private static final String FROM_KEY = "from";
    private static final String TO_KEY = "to";
    private static final String POS_KEY = "pos";
    private static final String STATUS_KEY = "status";
    private final Map<String, List<class_2338>> paths = new ConcurrentHashMap<String, List<class_2338>>();
    private final Map<String, Status> statuses = new ConcurrentHashMap<String, Status>();

    public static PathStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, PathStorage::new, PathStorage::fromNbt, KEY);
    }

    public static PathStorage fromNbt(class_2487 tag) {
        PathStorage storage = new PathStorage();
        class_2499 list = tag.method_10554(PATHS_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entry = list.method_10602(i);
            String from = entry.method_10558(FROM_KEY);
            String to = entry.method_10558(TO_KEY);
            String key = KeyUtil.pathKey(from, to);
            class_2499 posList = entry.method_10554(POS_KEY, 4);
            ArrayList<class_2338> positions = new ArrayList<class_2338>();
            for (class_2520 nbtElement : posList) {
                positions.add(class_2338.method_10092((long)((class_2503)nbtElement).method_10699()));
            }
            storage.paths.put(key, positions);
            Status status = NbtUtils.getEnumOrDefault(entry, STATUS_KEY, Status.class, Status.READY);
            storage.statuses.put(key, status);
        }
        return storage;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        for (Map.Entry<String, List<class_2338>> entry : this.paths.entrySet()) {
            String[] ids = KeyUtil.parsePathKey(entry.getKey());
            if (ids.length != 2) continue;
            class_2487 elem = new class_2487();
            elem.method_10582(FROM_KEY, ids[0]);
            elem.method_10582(TO_KEY, ids[1]);
            class_2499 posList = new class_2499();
            for (class_2338 pos : entry.getValue()) {
                posList.add((Object)class_2503.method_23251((long)pos.method_10063()));
            }
            elem.method_10566(POS_KEY, (class_2520)posList);
            Status st = this.statuses.getOrDefault(entry.getKey(), Status.PENDING);
            elem.method_10582(STATUS_KEY, st.name());
            list.add((Object)elem);
        }
        tag.method_10566(PATHS_KEY, (class_2520)list);
        return tag;
    }

    public void putPath(String from, String to, List<class_2338> path, Status status) {
        String key = KeyUtil.pathKey(from, to);
        this.paths.put(key, List.copyOf(path));
        this.statuses.put(key, status);
        this.method_80();
    }

    public void updatePath(String key, List<class_2338> path, Status status) {
        this.paths.put(key, List.copyOf(path));
        this.statuses.put(key, status);
        this.method_80();
    }

    public List<class_2338> getPath(String from, String to) {
        return this.paths.getOrDefault(KeyUtil.pathKey(from, to), List.of());
    }

    public List<class_2338> getPath(String key) {
        return this.paths.getOrDefault(key, List.of());
    }

    public Status getStatus(String key) {
        return this.statuses.getOrDefault(key, Status.PENDING);
    }

    public void setStatus(String key, Status status) {
        this.statuses.put(key, status);
        this.method_80();
    }

    public Map<String, Status> allStatuses() {
        return Map.copyOf(this.statuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryMarkProcessing(String key) {
        Map<String, Status> map = this.statuses;
        synchronized (map) {
            Status cur = this.statuses.get(key);
            if (cur != Status.PENDING) {
                return false;
            }
            this.statuses.put(key, Status.PROCESSING);
            this.method_80();
            return true;
        }
    }

    public List<String> getPendingForChunk(class_1923 chunk) {
        ArrayList<String> out = new ArrayList<String>();
        block0: for (Map.Entry<String, List<class_2338>> e : this.paths.entrySet()) {
            if (this.getStatus(e.getKey()) != Status.PENDING) continue;
            for (class_2338 p : e.getValue()) {
                if (!new class_1923(p).equals((Object)chunk)) continue;
                out.add(e.getKey());
                continue block0;
            }
        }
        return out;
    }

    public static enum Status {
        PENDING,
        PROCESSING,
        READY,
        FAILED;

    }
}

