/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_6833;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + StructureLocator.class.getSimpleName()));
    private static final DynamicCommandExceptionType INVALID_STRUCTURE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.locate.structure.invalid", (Object[])new Object[]{id}));
    private static final int MAX_RING_CANDIDATES_PER_CELL = 16;
    private static final Map<class_2378<class_3195>, Map<String, class_6885<class_3195>>> SELECTOR_CACHE = new WeakHashMap<class_2378<class_3195>, Map<String, class_6885<class_3195>>>();
    private static final Map<MinecraftServer, NegCache> NEGATIVE_CACHE = new WeakHashMap<MinecraftServer, NegCache>();

    private StructureLocator() {
    }

    private static List<class_6885<class_3195>> compileSelectors(class_2378<class_3195> registry, List<String> selectors) {
        Map cache = SELECTOR_CACHE.computeIfAbsent(registry, r -> new HashMap(selectors.size() * 2));
        class_7066 argType = new class_7066(class_7924.field_41246);
        ArrayList<class_6885<class_3195>> compiled = new ArrayList<class_6885<class_3195>>(selectors.size());
        for (String raw : selectors) {
            class_6885<class_3195> list = (class_6885<class_3195>)cache.get(raw);
            if (list == null) {
                try {
                    class_7066.class_7068 predicate = argType.method_41164(new StringReader(raw));
                    list = StructureLocator.getStructureList((class_7066.class_7068<class_3195>)predicate, registry).orElseThrow(() -> INVALID_STRUCTURE_EXCEPTION.create((Object)raw));
                    cache.put(raw, list);
                }
                catch (CommandSyntaxException ex) {
                    LOGGER.warn("Structure selector '{}' is invalid: {}", (Object)raw, (Object)ex.getMessage());
                    continue;
                }
            }
            compiled.add(list);
        }
        return compiled;
    }

    public static List<Pair<class_2338, String>> scanGridAsync(class_3218 world, class_2338 origin, int overallRadius, int scanRadius, List<String> structureSelectors) {
        return StructureLocator.scanGridAsync(world, origin, overallRadius, scanRadius, structureSelectors, true);
    }

    public static List<Pair<class_2338, String>> scanGridAsync(class_3218 world, class_2338 origin, int overallRadius, int scanRadius, List<String> structureSelectors, boolean allowChunkLoads) {
        PipelineProfiler.increment("structure_locator.invocations");
        PipelineProfiler.recordValue("structure_locator.selector_input", structureSelectors.size());
        PipelineProfiler.recordValue("structure_locator.overall_radius", overallRadius);
        PipelineProfiler.recordValue("structure_locator.scan_radius", scanRadius);
        PipelineProfiler.increment("structure_locator.allow_chunk_loads." + (allowChunkLoads ? "enabled" : "disabled"));
        try (PipelineProfiler.Section total = PipelineProfiler.openSection("structure_locator.total");){
            List<Pair<class_2338, String>> found;
            List planned;
            PlacementIndex index;
            List<class_6885<class_3195>> compiledSelectors;
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
            try (Object compile = PipelineProfiler.openSection("structure_locator.compile_selectors");){
                compiledSelectors = StructureLocator.compileSelectors((class_2378<class_3195>)registry, structureSelectors);
            }
            PipelineProfiler.recordValue("structure_locator.compiled_selector_groups", compiledSelectors.size());
            if (compiledSelectors.isEmpty()) {
                compile = Collections.emptyList();
                return compile;
            }
            try (PipelineProfiler.Section indexSection = PipelineProfiler.openSection("structure_locator.build_index");){
                index = StructureLocator.buildPlacementIndex(world, compiledSelectors);
            }
            int baseStep = scanRadius * 2 + 1;
            int step = StructureLocator.computeGridStepChunks(index, baseStep);
            int originChunkX = origin.method_10263() >> 4;
            int originChunkZ = origin.method_10260() >> 4;
            ArrayList<Cell> cells = new ArrayList<Cell>();
            for (int dx = -overallRadius; dx <= overallRadius; dx += step) {
                for (int dz = -overallRadius; dz <= overallRadius; dz += step) {
                    int cx = originChunkX + dx;
                    int cz = originChunkZ + dz;
                    class_2338 cellCenter = new class_2338((cx << 4) + 8, origin.method_10264(), (cz << 4) + 8);
                    cells.add(new Cell(cx, cz, cellCenter));
                }
            }
            PipelineProfiler.recordValue("structure_locator.grid_cells", cells.size());
            try (PipelineProfiler.Section planning = PipelineProfiler.openSection("structure_locator.plan_candidates");){
                planned = (List)((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> cells.parallelStream().flatMap(cell -> StructureLocator.planCandidatesForCell(index, cell, scanRadius)).collect(Collectors.toCollection(ArrayList::new)))).join();
            }
            PipelineProfiler.recordValue("structure_locator.planned_candidates", planned.size());
            try (PipelineProfiler.Section resolve = PipelineProfiler.openSection("structure_locator.resolve_candidates");){
                found = StructureLocator.resolveCandidatesOnMainThread(world, (class_2378<class_3195>)registry, index, planned, allowChunkLoads);
            }
            PipelineProfiler.recordValue("structure_locator.resolved_structures", found.size());
            StructureLocator.schedulePersistence(world, found);
            List<Pair<class_2338, String>> list = found;
            return list;
        }
    }

    private static PlacementIndex buildPlacementIndex(class_3218 world, List<class_6885<class_3195>> compiledSelectors) {
        class_7869 calc = world.method_14178().method_46642();
        HashMap<class_6872, Set<class_6880<class_3195>>> randomGroups = new HashMap<class_6872, Set<class_6880<class_3195>>>();
        HashMap<class_6871, Set<class_6880<class_3195>>> ringGroups = new HashMap<class_6871, Set<class_6880<class_3195>>>();
        HashMap<class_6871, List<class_1923>> ringPositions = new HashMap<class_6871, List<class_1923>>();
        for (class_6885<class_3195> list : compiledSelectors) {
            for (class_6880 entry : list) {
                for (class_6874 p : calc.method_46708(entry)) {
                    if (p instanceof class_6872) {
                        class_6872 rsp = (class_6872)p;
                        randomGroups.computeIfAbsent(rsp, __ -> new HashSet()).add(entry);
                        continue;
                    }
                    if (!(p instanceof class_6871)) continue;
                    class_6871 cr = (class_6871)p;
                    ringGroups.computeIfAbsent(cr, __ -> new HashSet()).add(entry);
                }
            }
        }
        for (class_6871 cr : ringGroups.keySet()) {
            List positions = calc.method_46707(cr);
            if (positions == null) {
                throw new IllegalStateException("Missing ring placement positions");
            }
            ringPositions.put(cr, positions);
        }
        return new PlacementIndex(randomGroups, ringGroups, ringPositions, calc.method_46714());
    }

    private static Stream<Candidate> planCandidatesForCell(PlacementIndex index, Cell cell, int radius) {
        class_6872 placement;
        ArrayList<Candidate> out = new ArrayList<Candidate>();
        for (Map.Entry<class_6872, Set<class_6880<class_3195>>> entry : index.randomGroups.entrySet()) {
            placement = entry.getKey();
            int spacing = placement.method_41632();
            for (int k = 0; k <= radius; ++k) {
                for (int dj = -k; dj <= k; ++dj) {
                    boolean edgeZ = dj == -k || dj == k;
                    for (int di = -k; di <= k; ++di) {
                        boolean edgeX;
                        boolean bl = edgeX = di == -k || di == k;
                        if (!edgeX && !edgeZ) continue;
                        int l = cell.centerChunkX + spacing * di;
                        int m = cell.centerChunkZ + spacing * dj;
                        class_1923 start = placement.method_40169(index.structureSeed, l, m);
                        int px = start.method_8326() + 8;
                        int pz = start.method_8328() + 8;
                        int dist2 = StructureLocator.sq(px - cell.worldCenter.method_10263()) + StructureLocator.sq(pz - cell.worldCenter.method_10260());
                        out.add(new Candidate(start, dist2, (class_6874)placement, entry.getValue()));
                    }
                }
            }
        }
        for (Map.Entry<class_6872, Set<class_6880<class_3195>>> entry : index.ringGroups.entrySet()) {
            placement = (class_6871)entry.getKey();
            List<class_1923> positions = index.ringPositions.get(placement);
            if (positions == null || positions.isEmpty()) continue;
            positions.stream().map(cp -> {
                int px = class_4076.method_32205((int)cp.field_9181, (int)8);
                int pz = class_4076.method_32205((int)cp.field_9180, (int)8);
                int d2 = StructureLocator.sq(px - cell.worldCenter.method_10263()) + StructureLocator.sq(pz - cell.worldCenter.method_10260());
                return new Object[]{cp, d2};
            }).sorted(Comparator.comparingInt(o -> (Integer)o[1])).limit(16L).forEach(arg_0 -> StructureLocator.lambda$planCandidatesForCell$9(out, (class_6871)placement, entry, arg_0));
        }
        out.sort(Comparator.comparingInt(Candidate::prioritySq));
        return out.stream();
    }

    private static int sq(int v) {
        return v * v;
    }

    private static List<Pair<class_2338, String>> resolveCandidatesOnMainThread(class_3218 world, class_2378<class_3195> registry, PlacementIndex index, List<Candidate> candidates, boolean allowChunkLoads) {
        LongOpenHashSet seenXZ = new LongOpenHashSet();
        ArrayList<Pair<class_2338, String>> found = new ArrayList<Pair<class_2338, String>>(Math.min(128, candidates.size()));
        LongOpenHashSet neg = StructureLocator.getOrCreateNegativeCache(world);
        class_5138 accessor = world.method_27056();
        PipelineProfiler.recordValue("structure_locator.resolve_candidates_input", candidates.size());
        for (Candidate c : candidates) {
            class_2791 chunk;
            PipelineProfiler.increment("structure_locator.candidate_examined");
            long negKey = StructureLocator.packNegKey(c.pos, c.placement);
            if (neg.contains(negKey)) {
                PipelineProfiler.increment("structure_locator.negative_cache_hit");
                continue;
            }
            boolean needChunk = false;
            PipelineProfiler.recordValue("structure_locator.structures_per_candidate", c.structs.size());
            for (class_6880<class_3195> s : c.structs) {
                class_6833 presence;
                PipelineProfiler.increment("structure_locator.presence_checks");
                try (PipelineProfiler.Section presenceTimer = PipelineProfiler.openSection("structure_locator.presence_check");){
                    presence = accessor.method_39783(c.pos, (class_3195)s.comp_349(), true);
                }
                if (presence == class_6833.field_36239) {
                    PipelineProfiler.increment("structure_locator.presence_positive");
                    class_2338 hit = c.placement.method_41636(c.pos);
                    long keyXZ = class_2338.method_10064((int)hit.method_10263(), (int)0, (int)hit.method_10260());
                    if (seenXZ.add(keyXZ)) {
                        class_2960 id = registry.method_10221((Object)((class_3195)s.comp_349()));
                        found.add((Pair<class_2338, String>)Pair.of((Object)new class_2338(hit.method_10263(), CacheManager.getHeight(world, hit.method_10263(), hit.method_10260()), hit.method_10260()), (Object)(id == null ? "unknown" : id.toString())));
                        PipelineProfiler.increment("structure_locator.found_structures");
                    }
                    needChunk = false;
                    continue;
                }
                if (presence == class_6833.field_36240) continue;
                needChunk = true;
                PipelineProfiler.increment("structure_locator.chunk_confirmation_needed");
            }
            if (!needChunk) {
                neg.add(negKey);
                PipelineProfiler.increment("structure_locator.negative_cache_store");
                continue;
            }
            if (!allowChunkLoads) {
                DebugLog.info(LOGGER, "Skipping chunk load for candidate {} due to allowChunkLoads=false", c.pos);
                PipelineProfiler.increment("structure_locator.chunk_loads_skipped");
                continue;
            }
            PipelineProfiler.increment("structure_locator.chunk_load_requests");
            try (PipelineProfiler.Section chunkTimer = PipelineProfiler.openSection("structure_locator.chunk_load");){
                chunk = world.method_22342(c.pos.field_9181, c.pos.field_9180, class_2806.field_16423);
            }
            PipelineProfiler.increment("structure_locator.chunk_loads_completed");
            class_4076 secPos = class_4076.method_33705((class_2791)chunk);
            boolean any = false;
            for (class_6880<class_3195> s : c.structs) {
                class_3449 start = accessor.method_26975(secPos, (class_3195)s.comp_349(), (class_2810)chunk);
                if (start == null || !start.method_16657()) continue;
                PipelineProfiler.increment("structure_locator.chunk_resolve_success");
                class_2338 hit = c.placement.method_41636(start.method_34000());
                long keyXZ = class_2338.method_10064((int)hit.method_10263(), (int)0, (int)hit.method_10260());
                if (seenXZ.add(keyXZ)) {
                    class_2960 id = registry.method_10221((Object)((class_3195)s.comp_349()));
                    found.add((Pair<class_2338, String>)Pair.of((Object)new class_2338(hit.method_10263(), CacheManager.getHeight(world, hit.method_10263(), hit.method_10260()), hit.method_10260()), (Object)(id == null ? "unknown" : id.toString())));
                    PipelineProfiler.increment("structure_locator.found_structures");
                }
                any = true;
            }
            if (any) continue;
            neg.add(negKey);
            PipelineProfiler.increment("structure_locator.negative_cache_store");
        }
        return found;
    }

    private static LongOpenHashSet getOrCreateNegativeCache(class_3218 world) {
        MinecraftServer server = world.method_8503();
        long seed = world.method_8412();
        NegCache nc = NEGATIVE_CACHE.get(server);
        if (nc == null || nc.seed != seed) {
            nc = new NegCache(seed);
            NEGATIVE_CACHE.put(server, nc);
        }
        return nc.set;
    }

    private static long packNegKey(class_1923 pos, class_6874 placement) {
        long a = class_1923.method_8331((int)pos.field_9181, (int)pos.field_9180);
        int b = System.identityHashCode(placement);
        return a ^ (long)b << 1;
    }

    private static void schedulePersistence(class_3218 world, List<Pair<class_2338, String>> found) {
        if (found.isEmpty()) {
            return;
        }
        MinecraftServer server = world.method_8503();
        server.execute(() -> {
            RoadGraphState graph = RoadGraphState.get(world);
            for (Pair pair : found) {
                Node node = graph.addNodeWithEdges((class_2338)pair.getFirst(), (String)pair.getSecond());
                DebugLog.info(LOGGER, "Added node {} at {} ({})", node.id(), node.pos(), pair.getSecond());
            }
            graph.method_80();
        });
    }

    private static Optional<? extends class_6885<class_3195>> getStructureList(class_7066.class_7068<class_3195> predicate, class_2378<class_3195> registry) {
        return (Optional)predicate.method_41173().map(key -> registry.method_40264(key).map(xva$0 -> class_6885.method_40246((class_6880[])new class_6880[]{xva$0})), arg_0 -> registry.method_40266(arg_0));
    }

    private static int computeGridStepChunks(PlacementIndex index, int fallbackStep) {
        int minSpacing = Integer.MAX_VALUE;
        for (class_6872 rsp : index.randomGroups.keySet()) {
            minSpacing = Math.min(minSpacing, rsp.method_41632());
        }
        if (minSpacing != Integer.MAX_VALUE) {
            int step = Math.max(fallbackStep, minSpacing);
            DebugLog.info(LOGGER, "Grid step optimization: fallbackStep={}, minSpacing={}, chosenStep={}", fallbackStep, minSpacing, step);
            return step;
        }
        return fallbackStep;
    }

    private static /* synthetic */ void lambda$planCandidatesForCell$9(List out, class_6871 placement, Map.Entry e, Object[] o) {
        out.add(new Candidate((class_1923)o[0], (Integer)o[1], (class_6874)placement, (Set)e.getValue()));
    }

    private record PlacementIndex(Map<class_6872, Set<class_6880<class_3195>>> randomGroups, Map<class_6871, Set<class_6880<class_3195>>> ringGroups, Map<class_6871, List<class_1923>> ringPositions, long structureSeed) {
    }

    private record Cell(int centerChunkX, int centerChunkZ, class_2338 worldCenter) {
    }

    private record Candidate(class_1923 pos, int prioritySq, class_6874 placement, Set<class_6880<class_3195>> structs) {
    }

    private static final class NegCache {
        final long seed;
        final LongOpenHashSet set = new LongOpenHashSet();

        NegCache(long seed) {
            this.seed = seed;
        }
    }
}

