/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public final class BlockPalette {
    private final List<Entry> entries;
    private final int totalWeight;

    private BlockPalette(List<Entry> entries, int totalWeight) {
        this.entries = entries;
        this.totalWeight = totalWeight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public class_2680 pick(class_5819 random) {
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("BlockPalette is empty");
        }
        int r = random.method_43048(this.totalWeight);
        for (Entry e : this.entries) {
            if (r < e.weight) {
                return e.state;
            }
            r -= e.weight;
        }
        return this.entries.get((int)0).state;
    }

    public static final class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int totalWeight;

        public Builder add(class_2680 state, int weight) {
            this.entries.add(new Entry(state, weight));
            this.totalWeight += weight;
            return this;
        }

        public BlockPalette build() {
            return new BlockPalette(List.copyOf(this.entries), this.totalWeight);
        }
    }

    private record Entry(class_2680 state, int weight) {
    }
}

