/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.noiilive.jojowor.JojoworModTags;
import net.noiilive.jojowor.ZoomHandler;
import net.noiilive.jojowor.network.JojoworModVariables;

@OnlyIn(value=Dist.CLIENT)
public class GlowHandler {
    public static int getGlowColor(Player player, Entity entity) {
        TamableAnimal tamable;
        JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (player == entity) {
            if (vars.GlowingAura && (vars.StandSummoned || vars.StandHalfSummoned)) {
                return GlowHandler.getAuraColorHex(vars.AuraColor);
            }
            return -1;
        }
        if (vars.GlowingAura && vars.StandHalfSummoned && entity.getType().is(JojoworModTags.HALF_STANDS) && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isTame() && tamable.getOwnerUUID() != null && tamable.getOwnerUUID().equals(player.getUUID()) && !Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return GlowHandler.getAuraColorHex(vars.AuraColor);
        }
        if (ZoomHandler.isZoomed()) {
            Vec3 center;
            Vec3 start = player.getEyePosition(1.0f);
            Vec3 lookVec = player.getViewVector(1.0f);
            double maxDistance = 100.0;
            Vec3 end = start.add(lookVec.scale(maxDistance));
            Level level = player.level();
            BlockHitResult blockHit = level.clip(new ClipContext(start, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
            double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxDistance : blockHit.getLocation().distanceTo(start);
            AABB entitySearchBox = new AABB(start, end).inflate(1.0);
            Entity closestEntity = null;
            double closestEntityDist = maxDistance;
            for (Entity e2 : level.getEntities((Entity)player, entitySearchBox, e -> e.isPickable() && !e.getType().is(JojoworModTags.NON_TARGETABLE) && e != player)) {
                double dist;
                AABB bb = e2.getBoundingBox().inflate(0.3);
                Optional intercept = bb.clip(start, end);
                if (!intercept.isPresent() || !((dist = start.distanceTo((Vec3)intercept.get())) < closestEntityDist) || !(dist < blockHitDist)) continue;
                closestEntityDist = dist;
                closestEntity = e2;
            }
            if (closestEntity != null) {
                center = closestEntity.position();
            } else if (blockHit.getType() != HitResult.Type.MISS) {
                center = Vec3.atCenterOf((Vec3i)blockHit.getBlockPos());
            } else {
                return -1;
            }
            double radius = 5.0 + vars.StandPrecision / 15.0;
            if (entity.position().distanceTo(center) <= radius) {
                return 11035135;
            }
        }
        return -1;
    }

    private static int getAuraColorHex(String aura) {
        return switch (aura) {
            case "White" -> 0xFFFFFF;
            case "Red" -> 16739965;
            case "Orange" -> 16752215;
            case "Yellow" -> 16763981;
            case "Green" -> 8781703;
            case "Light Blue" -> 8252415;
            case "Blue" -> 8884735;
            case "Purple" -> 12220671;
            case "Pink" -> 16755701;
            default -> -1;
        };
    }
}

