/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeldio<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"modeldio"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public Modeldio(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(6, 61).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(56, 16).mirror().addBox(-1.461f, -3.1387f, 3.9558f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(56, 6).mirror().addBox(-1.461f, -3.1387f, -1.0442f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.4485f, (float)-5.6305f, (float)-1.3281f, (float)0.3595f, (float)0.0503f, (float)-0.5392f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(56, 16).addBox(-2.539f, -3.1387f, 3.9558f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(56, 6).addBox(-2.539f, -3.1387f, -1.0442f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.4485f, (float)-5.6305f, (float)-1.3281f, (float)0.3595f, (float)-0.0503f, (float)0.5392f));
        PartDefinition head_r3 = head.addOrReplaceChild("head_r3", CubeListBuilder.create().texOffs(48, 41).addBox(-4.0f, -3.2046f, 6.4163f, 8.0f, 6.0f, 3.0f, new CubeDeformation(0.02f)).texOffs(0, 16).addBox(-4.0f, -3.2046f, -0.5837f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-3.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head_r4 = head.addOrReplaceChild("head_r4", CubeListBuilder.create().texOffs(8, 61).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.25f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition head_r5 = head.addOrReplaceChild("head_r5", CubeListBuilder.create().texOffs(30, 16).addBox(-4.5f, -2.5f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.51f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.5f, (float)3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head_r6 = head.addOrReplaceChild("head_r6", CubeListBuilder.create().texOffs(56, 0).addBox(-4.0f, -2.0f, -1.5f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.3256f, (float)-4.5374f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 29).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(32, 0).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso_r1 = body.addOrReplaceChild("torso_r1", CubeListBuilder.create().texOffs(40, 25).addBox(-2.0f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition torso_r2 = body.addOrReplaceChild("torso_r2", CubeListBuilder.create().texOffs(48, 50).mirror().addBox(-4.0f, 0.0f, -2.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition torso_r3 = body.addOrReplaceChild("torso_r3", CubeListBuilder.create().texOffs(48, 50).addBox(0.0f, 0.0f, -2.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 45).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 25).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 45).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 25).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 45).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 45).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition torso_r4 = left_leg.addOrReplaceChild("torso_r4", CubeListBuilder.create().texOffs(0, 61).addBox(-2.0f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)4.75f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 45).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 45).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition torso_r5 = right_leg.addOrReplaceChild("torso_r5", CubeListBuilder.create().texOffs(0, 61).mirror().addBox(-1.0f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.75f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

