/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.item;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.noiilive.jojowor.entity.IronKnifeProjectileEntity;
import net.noiilive.jojowor.init.JojoworModEntities;

public class IronKnifeItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 50;
        }

        public float getSpeed() {
            return 2.0f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 14;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT});
        }
    };

    public IronKnifeItem() {
        super(TOOL_TIER, new Item.Properties().durability(50).rarity(Rarity.COMMON).attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)1.0f, (float)-2.0f)));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 1.5f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player.getAbilities().instabuild || !this.findAmmo(player).isEmpty()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useDuration = this.getUseDuration(itemstack, entity) - time;
            if (useDuration >= 5 && !itemstack.isEmpty()) {
                HolderLookup.RegistryLookup registry = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                ResourceKey preservationKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"jojowor:preservation"));
                ResourceKey obedienceKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"jojowor:obedience"));
                boolean hasPreservation = itemstack.getEnchantmentLevel((Holder)registry.getOrThrow(preservationKey)) > 0;
                int obedienceLevel = itemstack.getEnchantmentLevel((Holder)registry.getOrThrow(obedienceKey));
                if (!player.getAbilities().instabuild) {
                    itemstack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
                    if (!hasPreservation) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
                IronKnifeProjectileEntity projectile = new IronKnifeProjectileEntity((EntityType<? extends IronKnifeProjectileEntity>)((EntityType)JojoworModEntities.IRON_KNIFE_PROJECTILE.get()), entity, world, itemstack.copy());
                projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 3.15f, 1.0f);
                projectile.setObedienceLevel(obedienceLevel);
                projectile.setOwner((LivingEntity)player);
                world.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (hasPreservation || player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                world.addFreshEntity((Entity)projectile);
            }
        }
    }

    private ItemStack findAmmo(Player player) {
        ItemStack stack = player.getItemInHand(player.getUsedItemHand());
        if (!stack.isEmpty() && stack.getItem() instanceof IronKnifeItem) {
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

