/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.noiilive.jojowor.JojoworMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class JojoworModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"jojowor");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        JojoworMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data, int target) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess()));
            buffer.writeInt(message.target());
        }, buffer -> {
            CompoundTag nbt = buffer.readNbt();
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables(), buffer.readInt());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), nbt);
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().level().getEntity(message.target()).getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double PlayerLevel = 1.0;
        public double PlayerEXP = 0.0;
        public double PlayerMaxEXP = 100.0;
        public double PlayerSkillPoints = 5.0;
        public double PlayerStrength = 0.0;
        public double PlayerVitality = 0.0;
        public double PlayerAgility = 0.0;
        public double PlayerIntelligence = 0.0;
        public String CurrentGuild = "None";
        public String GuildInvites = "";
        public String PlayerSpecilization = "None";
        public double AddPlayerSkillPoints = 1.0;
        public double PlayerSpecMastery = 0.0;
        public String PlayerSpecPath = "None";
        public String BaseSkills = "";
        public String BasePerks = "";
        public String SpecSkills = "";
        public String SpecPerks = "";
        public String PlayerStand = "None";
        public String StandSkills = "";
        public String StandPerks = "";
        public double AbilityBar = 1.0;
        public boolean StandSummoned = false;
        public boolean HalfSummon = true;
        public String StandSkin = "Base";
        public double EffectDamageCooldown = 0.0;
        public double Cooldown1a = 0.0;
        public double Cooldown2a = 0.0;
        public double Cooldown3a = 0.0;
        public double Cooldown4a = 0.0;
        public double Cooldown5a = 0.0;
        public double Cooldown1b = 0.0;
        public double Cooldown2b = 0.0;
        public double Cooldown3b = 0.0;
        public double Cooldown4b = 0.0;
        public double Cooldown5b = 0.0;
        public String Ability1a = "None";
        public String Ability2a = "None";
        public String Ability3a = "None";
        public String Ability4a = "None";
        public String Ability5a = "None";
        public String Ability1b = "None";
        public String Ability2b = "None";
        public String Ability3b = "None";
        public String Ability4b = "None";
        public String Ability5b = "None";
        public String GUISelectedEntry = "";
        public double CombatStep = 1.0;
        public String SwitchMode = "Keybind";
        public double AbilitySlotSelected = 1.0;
        public boolean KeyHeld = false;
        public double StandAttackCooldown = 0.0;
        public String StandSkinsUnlocked = "Base, ";
        public boolean StandHalfSummoned = false;
        public boolean NoCooldowns = false;
        public double InputDelay = 0.0;
        public double BlockedHits = 0.0;
        public double MaxBlocks = 5.0;
        public String BlockingState = "";
        public double BlockingCooldown = 0.0;
        public double ParryTimer = 0.0;
        public double ParryCooldown = 0.0;
        public boolean JoinedWorld = false;
        public double GuardReset = 0.0;
        public double StandPower = 0.0;
        public double StandSpeed = 0.0;
        public double StandEndurance = 0.0;
        public double StandPrecision = 0.0;
        public double StandPotential = 0.0;
        public double StandLevel = 1.0;
        public double StandEXP = 0.0;
        public double StandMaxEXP = 100.0;
        public double StandSkillPoints = 5.0;
        public double PassiveCooldown = 0.0;
        public boolean HoldingAbility = false;
        public String AbilityHeld = "";
        public double HeldAbilityCooldown = 0.0;
        public double HeldAbilityDuration = 0.0;
        public boolean ManualResummon = false;
        public double PlayerFOV = 0.0;
        public boolean InstantDespawn = false;
        public double DamageTaken = 0.0;
        public String AuraColor = "White";
        public boolean GlowingAura = true;
        public boolean AbilityUsed = false;
        public boolean AbilityKey1 = false;
        public boolean AbilityKey2 = false;
        public boolean AbilityKey3 = false;
        public boolean AbilityKey4 = false;
        public boolean AbilityKey5 = false;
        public boolean BlockKey = false;
        public boolean ShowCooldowns = false;
        public double StandOffsetX = 0.75;
        public double StandOffsetY = 0.5;
        public double StandOffsetZ = -0.75;
        public double StandRotation = 0.0;
        public boolean VoiceLines = false;
        public double StandIdle = 0.0;
        public boolean StepAssist = true;
        public boolean UsingEmote = false;
        public String Emote1 = "None";
        public String Emote2 = "None";
        public String Emote3 = "None";
        public String Emote4 = "None";
        public String Emote5 = "None";
        public String Emote6 = "None";
        public String Emote7 = "None";
        public String Emote8 = "None";
        public String EmoteUsed = "";
        public String UnlockedEmotes = "";
        public double EmoteX = 0.0;
        public double EmoteY = 0.0;
        public double EmoteZ = 0.0;
        public double EmoteCooldown = 0.0;
        public double EmotePage = 1.0;
        public boolean StandPiloting = false;
        public double PilotX = 0.0;
        public double PilotY = 0.0;
        public double PilotZ = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("PlayerLevel", this.PlayerLevel);
            nbt.putDouble("PlayerEXP", this.PlayerEXP);
            nbt.putDouble("PlayerMaxEXP", this.PlayerMaxEXP);
            nbt.putDouble("PlayerSkillPoints", this.PlayerSkillPoints);
            nbt.putDouble("PlayerStrength", this.PlayerStrength);
            nbt.putDouble("PlayerVitality", this.PlayerVitality);
            nbt.putDouble("PlayerAgility", this.PlayerAgility);
            nbt.putDouble("PlayerIntelligence", this.PlayerIntelligence);
            nbt.putString("CurrentGuild", this.CurrentGuild);
            nbt.putString("GuildInvites", this.GuildInvites);
            nbt.putString("PlayerSpecilization", this.PlayerSpecilization);
            nbt.putDouble("AddPlayerSkillPoints", this.AddPlayerSkillPoints);
            nbt.putDouble("PlayerSpecMastery", this.PlayerSpecMastery);
            nbt.putString("PlayerSpecPath", this.PlayerSpecPath);
            nbt.putString("BaseSkills", this.BaseSkills);
            nbt.putString("BasePerks", this.BasePerks);
            nbt.putString("SpecSkills", this.SpecSkills);
            nbt.putString("SpecPerks", this.SpecPerks);
            nbt.putString("PlayerStand", this.PlayerStand);
            nbt.putString("StandSkills", this.StandSkills);
            nbt.putString("StandPerks", this.StandPerks);
            nbt.putDouble("AbilityBar", this.AbilityBar);
            nbt.putBoolean("StandSummoned", this.StandSummoned);
            nbt.putBoolean("HalfSummon", this.HalfSummon);
            nbt.putString("StandSkin", this.StandSkin);
            nbt.putDouble("EffectDamageCooldown", this.EffectDamageCooldown);
            nbt.putDouble("Cooldown1a", this.Cooldown1a);
            nbt.putDouble("Cooldown2a", this.Cooldown2a);
            nbt.putDouble("Cooldown3a", this.Cooldown3a);
            nbt.putDouble("Cooldown4a", this.Cooldown4a);
            nbt.putDouble("Cooldown5a", this.Cooldown5a);
            nbt.putDouble("Cooldown1b", this.Cooldown1b);
            nbt.putDouble("Cooldown2b", this.Cooldown2b);
            nbt.putDouble("Cooldown3b", this.Cooldown3b);
            nbt.putDouble("Cooldown4b", this.Cooldown4b);
            nbt.putDouble("Cooldown5b", this.Cooldown5b);
            nbt.putString("Ability1a", this.Ability1a);
            nbt.putString("Ability2a", this.Ability2a);
            nbt.putString("Ability3a", this.Ability3a);
            nbt.putString("Ability4a", this.Ability4a);
            nbt.putString("Ability5a", this.Ability5a);
            nbt.putString("Ability1b", this.Ability1b);
            nbt.putString("Ability2b", this.Ability2b);
            nbt.putString("Ability3b", this.Ability3b);
            nbt.putString("Ability4b", this.Ability4b);
            nbt.putString("Ability5b", this.Ability5b);
            nbt.putString("GUISelectedEntry", this.GUISelectedEntry);
            nbt.putDouble("CombatStep", this.CombatStep);
            nbt.putString("SwitchMode", this.SwitchMode);
            nbt.putDouble("AbilitySlotSelected", this.AbilitySlotSelected);
            nbt.putBoolean("KeyHeld", this.KeyHeld);
            nbt.putDouble("StandAttackCooldown", this.StandAttackCooldown);
            nbt.putString("StandSkinsUnlocked", this.StandSkinsUnlocked);
            nbt.putBoolean("StandHalfSummoned", this.StandHalfSummoned);
            nbt.putBoolean("NoCooldowns", this.NoCooldowns);
            nbt.putDouble("InputDelay", this.InputDelay);
            nbt.putDouble("BlockedHits", this.BlockedHits);
            nbt.putDouble("MaxBlocks", this.MaxBlocks);
            nbt.putString("BlockingState", this.BlockingState);
            nbt.putDouble("BlockingCooldown", this.BlockingCooldown);
            nbt.putDouble("ParryTimer", this.ParryTimer);
            nbt.putDouble("ParryCooldown", this.ParryCooldown);
            nbt.putBoolean("JoinedWorld", this.JoinedWorld);
            nbt.putDouble("GuardReset", this.GuardReset);
            nbt.putDouble("StandPower", this.StandPower);
            nbt.putDouble("StandSpeed", this.StandSpeed);
            nbt.putDouble("StandEndurance", this.StandEndurance);
            nbt.putDouble("StandPrecision", this.StandPrecision);
            nbt.putDouble("StandPotential", this.StandPotential);
            nbt.putDouble("StandLevel", this.StandLevel);
            nbt.putDouble("StandEXP", this.StandEXP);
            nbt.putDouble("StandMaxEXP", this.StandMaxEXP);
            nbt.putDouble("StandSkillPoints", this.StandSkillPoints);
            nbt.putDouble("PassiveCooldown", this.PassiveCooldown);
            nbt.putBoolean("HoldingAbility", this.HoldingAbility);
            nbt.putString("AbilityHeld", this.AbilityHeld);
            nbt.putDouble("HeldAbilityCooldown", this.HeldAbilityCooldown);
            nbt.putDouble("HeldAbilityDuration", this.HeldAbilityDuration);
            nbt.putBoolean("ManualResummon", this.ManualResummon);
            nbt.putDouble("PlayerFOV", this.PlayerFOV);
            nbt.putBoolean("InstantDespawn", this.InstantDespawn);
            nbt.putDouble("DamageTaken", this.DamageTaken);
            nbt.putString("AuraColor", this.AuraColor);
            nbt.putBoolean("GlowingAura", this.GlowingAura);
            nbt.putBoolean("AbilityUsed", this.AbilityUsed);
            nbt.putBoolean("AbilityKey1", this.AbilityKey1);
            nbt.putBoolean("AbilityKey2", this.AbilityKey2);
            nbt.putBoolean("AbilityKey3", this.AbilityKey3);
            nbt.putBoolean("AbilityKey4", this.AbilityKey4);
            nbt.putBoolean("AbilityKey5", this.AbilityKey5);
            nbt.putBoolean("BlockKey", this.BlockKey);
            nbt.putBoolean("ShowCooldowns", this.ShowCooldowns);
            nbt.putDouble("StandOffsetX", this.StandOffsetX);
            nbt.putDouble("StandOffsetY", this.StandOffsetY);
            nbt.putDouble("StandOffsetZ", this.StandOffsetZ);
            nbt.putDouble("StandRotation", this.StandRotation);
            nbt.putBoolean("VoiceLines", this.VoiceLines);
            nbt.putDouble("StandIdle", this.StandIdle);
            nbt.putBoolean("StepAssist", this.StepAssist);
            nbt.putBoolean("UsingEmote", this.UsingEmote);
            nbt.putString("Emote1", this.Emote1);
            nbt.putString("Emote2", this.Emote2);
            nbt.putString("Emote3", this.Emote3);
            nbt.putString("Emote4", this.Emote4);
            nbt.putString("Emote5", this.Emote5);
            nbt.putString("Emote6", this.Emote6);
            nbt.putString("Emote7", this.Emote7);
            nbt.putString("Emote8", this.Emote8);
            nbt.putString("EmoteUsed", this.EmoteUsed);
            nbt.putString("UnlockedEmotes", this.UnlockedEmotes);
            nbt.putDouble("EmoteX", this.EmoteX);
            nbt.putDouble("EmoteY", this.EmoteY);
            nbt.putDouble("EmoteZ", this.EmoteZ);
            nbt.putDouble("EmoteCooldown", this.EmoteCooldown);
            nbt.putDouble("EmotePage", this.EmotePage);
            nbt.putBoolean("StandPiloting", this.StandPiloting);
            nbt.putDouble("PilotX", this.PilotX);
            nbt.putDouble("PilotY", this.PilotY);
            nbt.putDouble("PilotZ", this.PilotZ);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.PlayerLevel = nbt.getDouble("PlayerLevel");
            this.PlayerEXP = nbt.getDouble("PlayerEXP");
            this.PlayerMaxEXP = nbt.getDouble("PlayerMaxEXP");
            this.PlayerSkillPoints = nbt.getDouble("PlayerSkillPoints");
            this.PlayerStrength = nbt.getDouble("PlayerStrength");
            this.PlayerVitality = nbt.getDouble("PlayerVitality");
            this.PlayerAgility = nbt.getDouble("PlayerAgility");
            this.PlayerIntelligence = nbt.getDouble("PlayerIntelligence");
            this.CurrentGuild = nbt.getString("CurrentGuild");
            this.GuildInvites = nbt.getString("GuildInvites");
            this.PlayerSpecilization = nbt.getString("PlayerSpecilization");
            this.AddPlayerSkillPoints = nbt.getDouble("AddPlayerSkillPoints");
            this.PlayerSpecMastery = nbt.getDouble("PlayerSpecMastery");
            this.PlayerSpecPath = nbt.getString("PlayerSpecPath");
            this.BaseSkills = nbt.getString("BaseSkills");
            this.BasePerks = nbt.getString("BasePerks");
            this.SpecSkills = nbt.getString("SpecSkills");
            this.SpecPerks = nbt.getString("SpecPerks");
            this.PlayerStand = nbt.getString("PlayerStand");
            this.StandSkills = nbt.getString("StandSkills");
            this.StandPerks = nbt.getString("StandPerks");
            this.AbilityBar = nbt.getDouble("AbilityBar");
            this.StandSummoned = nbt.getBoolean("StandSummoned");
            this.HalfSummon = nbt.getBoolean("HalfSummon");
            this.StandSkin = nbt.getString("StandSkin");
            this.EffectDamageCooldown = nbt.getDouble("EffectDamageCooldown");
            this.Cooldown1a = nbt.getDouble("Cooldown1a");
            this.Cooldown2a = nbt.getDouble("Cooldown2a");
            this.Cooldown3a = nbt.getDouble("Cooldown3a");
            this.Cooldown4a = nbt.getDouble("Cooldown4a");
            this.Cooldown5a = nbt.getDouble("Cooldown5a");
            this.Cooldown1b = nbt.getDouble("Cooldown1b");
            this.Cooldown2b = nbt.getDouble("Cooldown2b");
            this.Cooldown3b = nbt.getDouble("Cooldown3b");
            this.Cooldown4b = nbt.getDouble("Cooldown4b");
            this.Cooldown5b = nbt.getDouble("Cooldown5b");
            this.Ability1a = nbt.getString("Ability1a");
            this.Ability2a = nbt.getString("Ability2a");
            this.Ability3a = nbt.getString("Ability3a");
            this.Ability4a = nbt.getString("Ability4a");
            this.Ability5a = nbt.getString("Ability5a");
            this.Ability1b = nbt.getString("Ability1b");
            this.Ability2b = nbt.getString("Ability2b");
            this.Ability3b = nbt.getString("Ability3b");
            this.Ability4b = nbt.getString("Ability4b");
            this.Ability5b = nbt.getString("Ability5b");
            this.GUISelectedEntry = nbt.getString("GUISelectedEntry");
            this.CombatStep = nbt.getDouble("CombatStep");
            this.SwitchMode = nbt.getString("SwitchMode");
            this.AbilitySlotSelected = nbt.getDouble("AbilitySlotSelected");
            this.KeyHeld = nbt.getBoolean("KeyHeld");
            this.StandAttackCooldown = nbt.getDouble("StandAttackCooldown");
            this.StandSkinsUnlocked = nbt.getString("StandSkinsUnlocked");
            this.StandHalfSummoned = nbt.getBoolean("StandHalfSummoned");
            this.NoCooldowns = nbt.getBoolean("NoCooldowns");
            this.InputDelay = nbt.getDouble("InputDelay");
            this.BlockedHits = nbt.getDouble("BlockedHits");
            this.MaxBlocks = nbt.getDouble("MaxBlocks");
            this.BlockingState = nbt.getString("BlockingState");
            this.BlockingCooldown = nbt.getDouble("BlockingCooldown");
            this.ParryTimer = nbt.getDouble("ParryTimer");
            this.ParryCooldown = nbt.getDouble("ParryCooldown");
            this.JoinedWorld = nbt.getBoolean("JoinedWorld");
            this.GuardReset = nbt.getDouble("GuardReset");
            this.StandPower = nbt.getDouble("StandPower");
            this.StandSpeed = nbt.getDouble("StandSpeed");
            this.StandEndurance = nbt.getDouble("StandEndurance");
            this.StandPrecision = nbt.getDouble("StandPrecision");
            this.StandPotential = nbt.getDouble("StandPotential");
            this.StandLevel = nbt.getDouble("StandLevel");
            this.StandEXP = nbt.getDouble("StandEXP");
            this.StandMaxEXP = nbt.getDouble("StandMaxEXP");
            this.StandSkillPoints = nbt.getDouble("StandSkillPoints");
            this.PassiveCooldown = nbt.getDouble("PassiveCooldown");
            this.HoldingAbility = nbt.getBoolean("HoldingAbility");
            this.AbilityHeld = nbt.getString("AbilityHeld");
            this.HeldAbilityCooldown = nbt.getDouble("HeldAbilityCooldown");
            this.HeldAbilityDuration = nbt.getDouble("HeldAbilityDuration");
            this.ManualResummon = nbt.getBoolean("ManualResummon");
            this.PlayerFOV = nbt.getDouble("PlayerFOV");
            this.InstantDespawn = nbt.getBoolean("InstantDespawn");
            this.DamageTaken = nbt.getDouble("DamageTaken");
            this.AuraColor = nbt.getString("AuraColor");
            this.GlowingAura = nbt.getBoolean("GlowingAura");
            this.AbilityUsed = nbt.getBoolean("AbilityUsed");
            this.AbilityKey1 = nbt.getBoolean("AbilityKey1");
            this.AbilityKey2 = nbt.getBoolean("AbilityKey2");
            this.AbilityKey3 = nbt.getBoolean("AbilityKey3");
            this.AbilityKey4 = nbt.getBoolean("AbilityKey4");
            this.AbilityKey5 = nbt.getBoolean("AbilityKey5");
            this.BlockKey = nbt.getBoolean("BlockKey");
            this.ShowCooldowns = nbt.getBoolean("ShowCooldowns");
            this.StandOffsetX = nbt.getDouble("StandOffsetX");
            this.StandOffsetY = nbt.getDouble("StandOffsetY");
            this.StandOffsetZ = nbt.getDouble("StandOffsetZ");
            this.StandRotation = nbt.getDouble("StandRotation");
            this.VoiceLines = nbt.getBoolean("VoiceLines");
            this.StandIdle = nbt.getDouble("StandIdle");
            this.StepAssist = nbt.getBoolean("StepAssist");
            this.UsingEmote = nbt.getBoolean("UsingEmote");
            this.Emote1 = nbt.getString("Emote1");
            this.Emote2 = nbt.getString("Emote2");
            this.Emote3 = nbt.getString("Emote3");
            this.Emote4 = nbt.getString("Emote4");
            this.Emote5 = nbt.getString("Emote5");
            this.Emote6 = nbt.getString("Emote6");
            this.Emote7 = nbt.getString("Emote7");
            this.Emote8 = nbt.getString("Emote8");
            this.EmoteUsed = nbt.getString("EmoteUsed");
            this.UnlockedEmotes = nbt.getString("UnlockedEmotes");
            this.EmoteX = nbt.getDouble("EmoteX");
            this.EmoteY = nbt.getDouble("EmoteY");
            this.EmoteZ = nbt.getDouble("EmoteZ");
            this.EmoteCooldown = nbt.getDouble("EmoteCooldown");
            this.EmotePage = nbt.getDouble("EmotePage");
            this.StandPiloting = nbt.getBoolean("StandPiloting");
            this.PilotX = nbt.getDouble("PilotX");
            this.PilotY = nbt.getDouble("PilotY");
            this.PilotZ = nbt.getDouble("PilotZ");
        }

        public void syncPlayerVariables(Entity entity) {
            if (!entity.level().isClientSide()) {
                for (Entity entityiterator : new ArrayList(entity.level().players())) {
                    if (!(entityiterator instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)entityiterator;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "jojowor_mapvars";
        public double GlobalCooldownCounter = 0.0;
        public boolean TimeStopGlobal = false;
        public String TimeStopGlobalOrigin = "";
        public double TimeStopGlobalDuration = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.GlobalCooldownCounter = nbt.getDouble("GlobalCooldownCounter");
            this.TimeStopGlobal = nbt.getBoolean("TimeStopGlobal");
            this.TimeStopGlobalOrigin = nbt.getString("TimeStopGlobalOrigin");
            this.TimeStopGlobalDuration = nbt.getDouble("TimeStopGlobalDuration");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("GlobalCooldownCounter", this.GlobalCooldownCounter);
            nbt.putBoolean("TimeStopGlobal", this.TimeStopGlobal);
            nbt.putString("TimeStopGlobalOrigin", this.TimeStopGlobalOrigin);
            nbt.putDouble("TimeStopGlobalDuration", this.TimeStopGlobalDuration);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "jojowor_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.PlayerLevel = original.PlayerLevel;
            clone.PlayerEXP = original.PlayerEXP;
            clone.PlayerMaxEXP = original.PlayerMaxEXP;
            clone.PlayerSkillPoints = original.PlayerSkillPoints;
            clone.PlayerStrength = original.PlayerStrength;
            clone.PlayerVitality = original.PlayerVitality;
            clone.PlayerAgility = original.PlayerAgility;
            clone.PlayerIntelligence = original.PlayerIntelligence;
            clone.CurrentGuild = original.CurrentGuild;
            clone.GuildInvites = original.GuildInvites;
            clone.PlayerSpecilization = original.PlayerSpecilization;
            clone.AddPlayerSkillPoints = original.AddPlayerSkillPoints;
            clone.PlayerSpecMastery = original.PlayerSpecMastery;
            clone.PlayerSpecPath = original.PlayerSpecPath;
            clone.BaseSkills = original.BaseSkills;
            clone.BasePerks = original.BasePerks;
            clone.SpecSkills = original.SpecSkills;
            clone.SpecPerks = original.SpecPerks;
            clone.PlayerStand = original.PlayerStand;
            clone.StandSkills = original.StandSkills;
            clone.StandPerks = original.StandPerks;
            clone.HalfSummon = original.HalfSummon;
            clone.StandSkin = original.StandSkin;
            clone.Cooldown1a = original.Cooldown1a;
            clone.Cooldown2a = original.Cooldown2a;
            clone.Cooldown3a = original.Cooldown3a;
            clone.Cooldown4a = original.Cooldown4a;
            clone.Cooldown5a = original.Cooldown5a;
            clone.Cooldown1b = original.Cooldown1b;
            clone.Cooldown2b = original.Cooldown2b;
            clone.Cooldown3b = original.Cooldown3b;
            clone.Cooldown4b = original.Cooldown4b;
            clone.Cooldown5b = original.Cooldown5b;
            clone.Ability1a = original.Ability1a;
            clone.Ability2a = original.Ability2a;
            clone.Ability3a = original.Ability3a;
            clone.Ability4a = original.Ability4a;
            clone.Ability5a = original.Ability5a;
            clone.Ability1b = original.Ability1b;
            clone.Ability2b = original.Ability2b;
            clone.Ability3b = original.Ability3b;
            clone.Ability4b = original.Ability4b;
            clone.Ability5b = original.Ability5b;
            clone.CombatStep = original.CombatStep;
            clone.SwitchMode = original.SwitchMode;
            clone.AbilitySlotSelected = original.AbilitySlotSelected;
            clone.StandSkinsUnlocked = original.StandSkinsUnlocked;
            clone.NoCooldowns = original.NoCooldowns;
            clone.MaxBlocks = original.MaxBlocks;
            clone.ParryTimer = original.ParryTimer;
            clone.JoinedWorld = original.JoinedWorld;
            clone.StandPower = original.StandPower;
            clone.StandSpeed = original.StandSpeed;
            clone.StandEndurance = original.StandEndurance;
            clone.StandPrecision = original.StandPrecision;
            clone.StandPotential = original.StandPotential;
            clone.StandLevel = original.StandLevel;
            clone.StandEXP = original.StandEXP;
            clone.StandMaxEXP = original.StandMaxEXP;
            clone.StandSkillPoints = original.StandSkillPoints;
            clone.AuraColor = original.AuraColor;
            clone.GlowingAura = original.GlowingAura;
            clone.AbilityKey5 = original.AbilityKey5;
            clone.ShowCooldowns = original.ShowCooldowns;
            clone.StandOffsetX = original.StandOffsetX;
            clone.StandOffsetY = original.StandOffsetY;
            clone.StandOffsetZ = original.StandOffsetZ;
            clone.StandRotation = original.StandRotation;
            clone.VoiceLines = original.VoiceLines;
            clone.StandIdle = original.StandIdle;
            clone.StepAssist = original.StepAssist;
            clone.Emote1 = original.Emote1;
            clone.Emote2 = original.Emote2;
            clone.Emote3 = original.Emote3;
            clone.Emote4 = original.Emote4;
            clone.Emote5 = original.Emote5;
            clone.Emote6 = original.Emote6;
            clone.Emote7 = original.Emote7;
            clone.Emote8 = original.Emote8;
            clone.UnlockedEmotes = original.UnlockedEmotes;
            clone.EmotePage = original.EmotePage;
            if (!event.isWasDeath()) {
                clone.AbilityBar = original.AbilityBar;
                clone.StandSummoned = original.StandSummoned;
                clone.EffectDamageCooldown = original.EffectDamageCooldown;
                clone.GUISelectedEntry = original.GUISelectedEntry;
                clone.KeyHeld = original.KeyHeld;
                clone.StandAttackCooldown = original.StandAttackCooldown;
                clone.StandHalfSummoned = original.StandHalfSummoned;
                clone.InputDelay = original.InputDelay;
                clone.BlockedHits = original.BlockedHits;
                clone.BlockingState = original.BlockingState;
                clone.BlockingCooldown = original.BlockingCooldown;
                clone.ParryCooldown = original.ParryCooldown;
                clone.GuardReset = original.GuardReset;
                clone.PassiveCooldown = original.PassiveCooldown;
                clone.HoldingAbility = original.HoldingAbility;
                clone.AbilityHeld = original.AbilityHeld;
                clone.HeldAbilityCooldown = original.HeldAbilityCooldown;
                clone.HeldAbilityDuration = original.HeldAbilityDuration;
                clone.ManualResummon = original.ManualResummon;
                clone.PlayerFOV = original.PlayerFOV;
                clone.InstantDespawn = original.InstantDespawn;
                clone.DamageTaken = original.DamageTaken;
                clone.AbilityUsed = original.AbilityUsed;
                clone.AbilityKey1 = original.AbilityKey1;
                clone.AbilityKey2 = original.AbilityKey2;
                clone.AbilityKey3 = original.AbilityKey3;
                clone.AbilityKey4 = original.AbilityKey4;
                clone.BlockKey = original.BlockKey;
                clone.UsingEmote = original.UsingEmote;
                clone.EmoteUsed = original.EmoteUsed;
                clone.EmoteX = original.EmoteX;
                clone.EmoteY = original.EmoteY;
                clone.EmoteZ = original.EmoteZ;
                clone.EmoteCooldown = original.EmoteCooldown;
                clone.StandPiloting = original.StandPiloting;
                clone.PilotX = original.PilotX;
                clone.PilotY = original.PilotY;
                clone.PilotZ = original.PilotZ;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

