/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.procedures;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.noiilive.jojowor.network.JojoworModVariables;

@EventBusSubscriber
public class TimeStopExplosionProcedure {
    private static final List<List<BlockPos>> explosionBlockQueues = new ArrayList<List<BlockPos>>();

    @SubscribeEvent
    public static void onExplode(ExplosionEvent.Detonate event) {
        Level worldAcc = event.getLevel();
        if (worldAcc.isClientSide()) {
            return;
        }
        Level world = worldAcc;
        if (!JojoworModVariables.MapVariables.get((LevelAccessor)world).TimeStopGlobal) {
            return;
        }
        ArrayList toBreak = new ArrayList(event.getAffectedBlocks());
        explosionBlockQueues.add(toBreak);
        event.getAffectedBlocks().clear();
        event.getAffectedEntities().clear();
    }

    public static void replayStoredExplosions(LevelAccessor worldAcc) {
        if (worldAcc.isClientSide()) {
            return;
        }
        Level world = (Level)worldAcc;
        for (List<BlockPos> blockList : explosionBlockQueues) {
            for (BlockPos pos : blockList) {
                BlockState state = world.getBlockState(pos);
                if (state.is(Blocks.TNT)) {
                    world.removeBlock(pos, false);
                    PrimedTnt primedTnt = new PrimedTnt(world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, null);
                    world.addFreshEntity((Entity)primedTnt);
                    continue;
                }
                world.destroyBlock(pos, true);
            }
        }
        explosionBlockQueues.clear();
    }
}

