/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.petemc.mutantszombies.entity.ZombieBruteEntity;
import org.jetbrains.annotations.NotNull;

public class ZombieBruteModel<T extends ZombieBruteEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mutantszombies", (String)"zombie_brute_layer"), "main");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public ZombieBruteModel(ModelPart root) {
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(71, 49).addBox(-6.0f, -4.0f, -7.0f, 11.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(69, 99).addBox(-5.0f, 4.0f, -6.0f, 9.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.0f, (float)-17.0f));
        partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -41.0f, -15.0f, 29.0f, 21.0f, 28.0f, new CubeDeformation(0.0f)).texOffs(0, 49).addBox(-13.0f, -20.0f, -9.0f, 25.0f, 7.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-20.0f, (float)-11.0f, (float)-7.0f));
        right_arm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(86, 0).addBox(-23.0f, 14.0f, 5.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        right_arm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 77).addBox(-4.0f, 0.0f, -3.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)19.0f, (float)-11.0f, (float)-7.0f));
        left_arm.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(80, 77).addBox(14.0f, 14.0f, 5.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        left_arm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(40, 77).addBox(13.0f, 0.0f, -3.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-19.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(98, 99).addBox(-2.0f, 11.0f, -3.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)11.0f, (float)-1.0f));
        left_leg.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(104, 70).addBox(3.0f, -7.0f, 1.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)13.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.6533f, -3.2527f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 19).addBox(-2.0f, 11.0f, -3.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)11.0f, (float)-2.0f));
        right_leg.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 105).addBox(-9.0f, -18.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)13.0f, (float)-3.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 49).addBox(-8.0f, -7.0f, 1.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)13.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        int i = ((ZombieBruteEntity)((Object)pEntity)).getAttackAnimationTick();
        if (i > 0) {
            this.right_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - pPartialTick), (float)10.0f);
            this.left_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - pPartialTick), (float)10.0f);
        } else {
            this.right_arm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
            this.left_arm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
        }
    }
}

