/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.petemc.mutantszombies.config.Config;
import net.petemc.mutantszombies.entity.ModEntities;
import net.petemc.mutantszombies.sound.ModSounds;
import org.jetbrains.annotations.NotNull;

public class MutantBruteEntity
extends Monster {
    private int attackTicksLeft;
    private int treeBreakCooldown = 30;

    public MutantBruteEntity(EntityType<MutantBruteEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 16;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{MutantBruteEntity.class}).m_26044_(new Class[]{MutantBruteEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, true));
        this.registerCustomGoals();
    }

    protected void registerCustomGoals() {
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_7472_(@NotNull DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
    }

    public SoundEvent m_7515_() {
        return ModSounds.ROAR_SOUND.get();
    }

    public void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.rooted_dirt.step"))), 0.15f, 1.0f);
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.husk.hurt")));
    }

    @NotNull
    public SoundEvent m_5592_() {
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.zombie.death")));
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public int getAttackAnimationTick() {
        return this.attackTicksLeft;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
        }
    }

    public boolean m_7327_(@NotNull Entity target) {
        boolean bl = super.m_7327_(target);
        this.attackTicksLeft = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return bl;
    }

    public void m_7822_(byte status) {
        if (status == 4) {
            this.attackTicksLeft = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(status);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (Config.getMutantBrutesBreakLogsAndLeavesAroundThem()) {
            if (this.treeBreakCooldown > 0) {
                --this.treeBreakCooldown;
            } else if (!this.m_9236_().f_46443_) {
                this.treeBreakCooldown = 40;
                AABB box = new AABB(this.m_20182_(), this.m_20182_());
                box = box.m_82400_(3.0);
                box = box.m_82377_(0.0, 1.0, 0.0);
                BlockPos.MutableBlockPos.m_121921_((AABB)box).filter(c -> this.m_9236_().m_8055_(c).m_60734_().toString().contains("leaves") || this.m_9236_().m_8055_(c).m_60734_().toString().contains("log")).forEach(c -> {
                    String blockName = this.m_9236_().m_8055_(c).m_60734_().toString();
                    if (!blockName.contains("securitycraft") || !blockName.contains("reinforced")) {
                        if (blockName.contains("leaves")) {
                            this.m_9236_().m_46961_(c, false);
                        }
                        if (blockName.contains("log")) {
                            this.m_9236_().m_46961_(c, true);
                        }
                    }
                });
            }
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.MUTANT_BRUTE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, serverLevel, reason, pos, random) -> Config.getMutantBrutesSpawnNaturally() && !serverLevel.m_204166_(pos).m_203565_(Biomes.f_48215_) && serverLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)serverLevel, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22284_, 18.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }
}

