/*
 * Decompiled with CFR 0.152.
 */
package dev.raenmel.chattint;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.raenmel.chattint.ColorPrefs;
import dev.raenmel.chattint.ColorUtil;
import java.lang.reflect.Field;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class ChatTint
implements ModInitializer {
    public static final String MOD_ID = "chattint";
    private static ColorPrefs PREFS;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            PREFS = ColorPrefs.load(server);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (PREFS != null) {
                PREFS.save(server);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ChatTint.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            if (sender == null) {
                return true;
            }
            MinecraftServer server = ChatTint.getServerFromPlayer(sender);
            ChatTint.broadcastColored(server, sender, message.method_46291().getString());
            return false;
        });
    }

    private static MinecraftServer getServerFromPlayer(class_3222 player) {
        try {
            Object serverWorld = player.getClass().getMethod("getServerWorld", new Class[0]).invoke((Object)player, new Object[0]);
            return (MinecraftServer)serverWorld.getClass().getMethod("getServer", new Class[0]).invoke(serverWorld, new Object[0]);
        }
        catch (ReflectiveOperationException ignored) {
            try {
                Object world = player.getClass().getMethod("getWorld", new Class[0]).invoke((Object)player, new Object[0]);
                return (MinecraftServer)world.getClass().getMethod("getServer", new Class[0]).invoke(world, new Object[0]);
            }
            catch (ReflectiveOperationException ignored2) {
                try {
                    return (MinecraftServer)player.getClass().getMethod("getServer", new Class[0]).invoke((Object)player, new Object[0]);
                }
                catch (ReflectiveOperationException ignored3) {
                    try {
                        Field f = player.getClass().getDeclaredField("server");
                        f.setAccessible(true);
                        return (MinecraftServer)f.get(player);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalStateException("Impossible de r\u00e9cup\u00e9rer MinecraftServer depuis ServerPlayerEntity", e);
                    }
                }
            }
        }
    }

    private static void registerCommands(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"color").then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> ColorUtil.suggestColors(b)).executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            String v = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            if (p == null) {
                return 0;
            }
            Optional<Integer> col = ColorUtil.parseColor(v);
            if (col.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Couleur invalide. Utilise un nom (red, gold...) ou #RRGGBB."), false);
                return 0;
            }
            PREFS.setNameColor(p.method_5667(), col.get());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Couleur du PSEUDO d\u00e9finie.").method_27694(s -> s.method_36139(((Integer)col.get()).intValue())), false);
            return 1;
        })))).then(class_2170.method_9247((String)"message").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> ColorUtil.suggestColors(b)).executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            String v = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            if (p == null) {
                return 0;
            }
            Optional<Integer> col = ColorUtil.parseColor(v);
            if (col.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Couleur invalide. Utilise un nom (red, gold...) ou #RRGGBB."), false);
                return 0;
            }
            PREFS.setMessageColor(p.method_5667(), col.get());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Couleur des MESSAGES d\u00e9finie.").method_27694(s -> s.method_36139(((Integer)col.get()).intValue())), false);
            return 1;
        })))).then(class_2170.method_9247((String)"reset").executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            if (p == null) {
                return 0;
            }
            PREFS.clear(p.method_5667());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Couleurs r\u00e9initialis\u00e9es."), false);
            return 1;
        })))).then(class_2170.method_9247((String)"preview").executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            if (p == null) {
                return 0;
            }
            int nCol = PREFS.getNameColor(p.method_5667()).orElse(class_124.field_1068.method_532());
            int mCol = PREFS.getMessageColor(p.method_5667()).orElse(class_124.field_1068.method_532());
            class_5250 preview = class_2561.method_43470((String)"<").method_10852((class_2561)p.method_5476().method_27661().method_27694(s -> s.method_36139(nCol))).method_10852((class_2561)class_2561.method_43470((String)"> ").method_27694(s -> s.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)"Exemple de message color\u00e9").method_27694(s -> s.method_36139(mCol)));
            p.method_7353((class_2561)preview, false);
            return 1;
        })));
    }

    private static void broadcastColored(MinecraftServer server, class_3222 sender, String rawMessage) {
        int nameCol = PREFS.getNameColor(sender.method_5667()).orElse(class_124.field_1068.method_532());
        int msgCol = PREFS.getMessageColor(sender.method_5667()).orElse(class_124.field_1068.method_532());
        class_5250 out = class_2561.method_43470((String)"<").method_10852((class_2561)sender.method_5476().method_27661().method_27694(s -> s.method_36139(nameCol))).method_10852((class_2561)class_2561.method_43470((String)"> ").method_27694(s -> s.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)rawMessage).method_27694(s -> s.method_36139(msgCol)));
        server.method_3760().method_43514((class_2561)out, false);
    }
}

