/*
 * Decompiled with CFR 0.152.
 */
package dev.raenmel.chattint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;

class ColorPrefs {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<UUID, Entry> map = new HashMap<UUID, Entry>();
    private Path file;

    ColorPrefs() {
    }

    public static ColorPrefs load(MinecraftServer server) {
        ColorPrefs prefs = new ColorPrefs();
        Path cfgDir = server.method_3831().resolve("config").resolve("chattint");
        try {
            Files.createDirectories(cfgDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        prefs.file = cfgDir.resolve("player_prefs.json");
        if (Files.exists(prefs.file, new LinkOption[0])) {
            try {
                String json = Files.readString(prefs.file);
                Map raw = (Map)GSON.fromJson(json, Map.class);
                if (raw != null) {
                    raw.forEach((k, v) -> {
                        try {
                            prefs.map.put(UUID.fromString(k), (Entry)GSON.fromJson(GSON.toJsonTree(v), Entry.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return prefs;
    }

    public void save(MinecraftServer server) {
        if (this.file == null) {
            return;
        }
        LinkedHashMap raw = new LinkedHashMap();
        this.map.forEach((k, v) -> raw.put(k.toString(), v));
        try {
            Files.writeString(this.file, (CharSequence)GSON.toJson(raw), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Optional<Integer> getNameColor(UUID u) {
        Entry e = this.map.get(u);
        return e != null && e.name != null ? Optional.of(e.name) : Optional.empty();
    }

    public Optional<Integer> getMessageColor(UUID u) {
        Entry e = this.map.get(u);
        return e != null && e.message != null ? Optional.of(e.message) : Optional.empty();
    }

    public void setNameColor(UUID u, int rgb) {
        this.map.computeIfAbsent((UUID)u, (Function<UUID, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setNameColor$2(java.util.UUID ), (Ljava/util/UUID;)Ldev/raenmel/chattint/ColorPrefs$Entry;)()).name = rgb;
    }

    public void setMessageColor(UUID u, int rgb) {
        this.map.computeIfAbsent((UUID)u, (Function<UUID, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setMessageColor$3(java.util.UUID ), (Ljava/util/UUID;)Ldev/raenmel/chattint/ColorPrefs$Entry;)()).message = rgb;
    }

    public void clear(UUID u) {
        this.map.remove(u);
    }

    private static /* synthetic */ Entry lambda$setMessageColor$3(UUID x) {
        return new Entry();
    }

    private static /* synthetic */ Entry lambda$setNameColor$2(UUID x) {
        return new Entry();
    }

    static class Entry {
        Integer name;
        Integer message;

        Entry() {
        }
    }
}

