/*
 * Decompiled with CFR 0.152.
 */
package dev.raenmel.chattint;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Optional<Integer> parseColor(String s) {
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        if ((s = s.trim().toLowerCase(Locale.ROOT)).startsWith("#") && s.length() == 7) {
            try {
                int rgb = Integer.parseInt(s.substring(1), 16);
                return Optional.of(rgb);
            }
            catch (NumberFormatException ignored) {
                return Optional.empty();
            }
        }
        for (class_124 f : class_124.values()) {
            if (!f.method_543() || !f.method_537().equalsIgnoreCase(s) || f.method_532() == null) continue;
            return Optional.of(f.method_532());
        }
        return Optional.empty();
    }

    public static CompletableFuture<Suggestions> suggestColors(SuggestionsBuilder b) {
        for (class_124 f : class_124.values()) {
            if (!f.method_543()) continue;
            b.suggest(f.method_537());
        }
        b.suggest("#ff0000").suggest("#00ff00").suggest("#3399ff");
        return b.buildFuture();
    }
}

